/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.config;

import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

class FlowExecutionListenerLoaderBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    private static final String FLOW_EXECUTION_LISTENER_LOADER_FACTORY_BEAN_CLASS_NAME = "org.springframework.webflow.config.FlowExecutionListenerLoaderFactoryBean";

    FlowExecutionListenerLoaderBeanDefinitionParser() {
    }

    protected String getBeanClassName(Element element) {
        return FLOW_EXECUTION_LISTENER_LOADER_FACTORY_BEAN_CLASS_NAME;
    }

    protected void doParse(Element element, BeanDefinitionBuilder definitionBuilder) {
        List<Element> listenerElements = DomUtils.getChildElementsByTagName(element, "listener");
        definitionBuilder.addPropertyValue("listeners", this.parseListenersWithCriteria(listenerElements));
    }

    private Map parseListenersWithCriteria(List listeners) {
        ManagedMap<RuntimeBeanReference, String> listenersWithCriteria = new ManagedMap<RuntimeBeanReference, String>(listeners.size());
        for (Element listenerElement : listeners) {
            RuntimeBeanReference ref = new RuntimeBeanReference(listenerElement.getAttribute("ref"));
            String criteria = listenerElement.getAttribute("criteria");
            listenersWithCriteria.put(ref, criteria);
        }
        return listenersWithCriteria;
    }
}

