/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.action;

import org.springframework.util.Assert;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.action.DefaultMultiActionMethodResolver;
import org.springframework.webflow.action.DispatchMethodInvoker;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class MultiAction
extends AbstractAction {
    private DispatchMethodInvoker methodInvoker;
    private MethodResolver methodResolver = new DefaultMultiActionMethodResolver();

    protected MultiAction() {
        this.setTarget(this);
    }

    public MultiAction(Object target) {
        this.setTarget(target);
    }

    protected final void setTarget(Object target) {
        this.methodInvoker = new DispatchMethodInvoker(target, new Class[]{RequestContext.class});
    }

    public MethodResolver getMethodResolver() {
        return this.methodResolver;
    }

    public void setMethodResolver(MethodResolver methodResolver) {
        this.methodResolver = methodResolver;
    }

    protected final Event doExecute(RequestContext context) throws Exception {
        String method = this.getMethodResolver().resolveMethod(context);
        Object obj = this.methodInvoker.invoke(method, new Object[]{context});
        if (obj != null) {
            Assert.isInstanceOf(Event.class, obj, "The '" + method + "' action execution method on target object '" + this.methodInvoker.getTarget() + "' did not return an Event object but '" + obj + "' of type " + obj.getClass().getName() + " -- " + "Programmer error; make sure the method signature conforms to " + "'public Event ${method}(RequestContext context) throws Exception;'.");
        }
        return (Event)obj;
    }

    public static interface MethodResolver {
        public String resolveMethod(RequestContext var1);
    }
}

