/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.action;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import org.springframework.binding.collection.AbstractCachingMapDecorator;
import org.springframework.binding.method.InvalidMethodKeyException;
import org.springframework.binding.method.MethodKey;
import org.springframework.util.Assert;

class DispatchMethodInvoker {
    private Object target;
    private Class[] parameterTypes;
    private Map<String, Method> methodCache = new AbstractCachingMapDecorator<String, Method>(){

        @Override
        public Method create(String key) {
            String methodName = key;
            try {
                return new MethodKey(DispatchMethodInvoker.this.target.getClass(), methodName, DispatchMethodInvoker.this.parameterTypes).getMethod();
            }
            catch (InvalidMethodKeyException e) {
                throw new MethodLookupException("Unable to resolve dispatch method " + e.getMethodKey() + "'; make sure the method name is correct and such a method is defined on targetClass " + DispatchMethodInvoker.this.target.getClass().getName(), e);
            }
        }
    };

    public DispatchMethodInvoker(Object target, Class[] parameterTypes) {
        Assert.notNull(target, "The target of a dispatch method invocation is required");
        this.target = target;
        this.parameterTypes = parameterTypes;
    }

    public Object getTarget() {
        return this.target;
    }

    public Class[] getParameterTypes() {
        return this.parameterTypes;
    }

    public Object invoke(String methodName, Object[] arguments) throws MethodLookupException, Exception {
        try {
            Method dispatchMethod = this.getDispatchMethod(methodName);
            return dispatchMethod.invoke(this.target, arguments);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof Exception) {
                throw (Exception)e.getTargetException();
            }
            throw (Error)e.getTargetException();
        }
    }

    private Method getDispatchMethod(String methodName) throws MethodLookupException {
        return this.methodCache.get(methodName);
    }

    public static class MethodLookupException
    extends RuntimeException {
        public MethodLookupException(String msg, Throwable ex) {
            super(msg, ex);
        }
    }
}

