/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.method.annotation;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.security.Principal;
import java.time.ZoneId;
import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpMethod;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.springframework.web.multipart.MultipartRequest;
import org.springframework.web.servlet.support.RequestContextUtils;

public class ServletRequestMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        Class<?> paramType = parameter.getParameterType();
        return WebRequest.class.isAssignableFrom(paramType) || ServletRequest.class.isAssignableFrom(paramType) || MultipartRequest.class.isAssignableFrom(paramType) || HttpSession.class.isAssignableFrom(paramType) || Principal.class.isAssignableFrom(paramType) || Locale.class.equals(paramType) || TimeZone.class.equals(paramType) || "java.time.ZoneId".equals(paramType.getName()) || InputStream.class.isAssignableFrom(paramType) || Reader.class.isAssignableFrom(paramType) || HttpMethod.class.equals(paramType);
    }

    @Override
    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws IOException {
        Class<?> paramType = parameter.getParameterType();
        if (WebRequest.class.isAssignableFrom(paramType)) {
            return webRequest;
        }
        HttpServletRequest request = webRequest.getNativeRequest(HttpServletRequest.class);
        if (ServletRequest.class.isAssignableFrom(paramType) || MultipartRequest.class.isAssignableFrom(paramType)) {
            Object nativeRequest = webRequest.getNativeRequest(paramType);
            if (nativeRequest == null) {
                throw new IllegalStateException("Current request is not of type [" + paramType.getName() + "]: " + request);
            }
            return nativeRequest;
        }
        if (HttpSession.class.isAssignableFrom(paramType)) {
            return request.getSession();
        }
        if (HttpMethod.class.equals(paramType)) {
            return ((ServletWebRequest)webRequest).getHttpMethod();
        }
        if (Principal.class.isAssignableFrom(paramType)) {
            return request.getUserPrincipal();
        }
        if (Locale.class.equals(paramType)) {
            return RequestContextUtils.getLocale(request);
        }
        if (TimeZone.class.equals(paramType)) {
            TimeZone timeZone = RequestContextUtils.getTimeZone(request);
            return timeZone != null ? timeZone : TimeZone.getDefault();
        }
        if ("java.time.ZoneId".equals(paramType.getName())) {
            return ZoneIdResolver.resolveZoneId(request);
        }
        if (InputStream.class.isAssignableFrom(paramType)) {
            return request.getInputStream();
        }
        if (Reader.class.isAssignableFrom(paramType)) {
            return request.getReader();
        }
        throw new UnsupportedOperationException("Unknown parameter type: " + paramType + " in method: " + parameter.getMethod());
    }

    private static class ZoneIdResolver {
        private ZoneIdResolver() {
        }

        public static Object resolveZoneId(HttpServletRequest request) {
            TimeZone timeZone = RequestContextUtils.getTimeZone(request);
            return timeZone != null ? timeZone.toZoneId() : ZoneId.systemDefault();
        }
    }
}

