/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.config;

import java.util.Map;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.web.servlet.config.MvcNamespaceUtils;
import org.springframework.web.servlet.handler.SimpleUrlHandlerMapping;
import org.springframework.web.servlet.mvc.ParameterizableViewController;
import org.w3c.dom.Element;

class ViewControllerBeanDefinitionParser
implements BeanDefinitionParser {
    private static final String HANDLER_MAPPING_BEAN_NAME = "org.springframework.web.servlet.config.viewControllerHandlerMapping";

    ViewControllerBeanDefinitionParser() {
    }

    @Override
    public BeanDefinition parse(Element element, ParserContext parserContext) {
        Map<String, RootBeanDefinition> urlMap;
        Object source = parserContext.extractSource(element);
        BeanDefinition handlerMappingDef = this.registerHandlerMapping(parserContext, source);
        MvcNamespaceUtils.registerDefaultComponents(parserContext, source);
        RootBeanDefinition viewControllerDef = new RootBeanDefinition(ParameterizableViewController.class);
        viewControllerDef.setSource(source);
        if (element.hasAttribute("view-name")) {
            viewControllerDef.getPropertyValues().add("viewName", element.getAttribute("view-name"));
        }
        if (handlerMappingDef.getPropertyValues().contains("urlMap")) {
            urlMap = (Map)handlerMappingDef.getPropertyValues().getPropertyValue("urlMap").getValue();
        } else {
            urlMap = new ManagedMap();
            handlerMappingDef.getPropertyValues().add("urlMap", urlMap);
        }
        urlMap.put(element.getAttribute("path"), viewControllerDef);
        return null;
    }

    private BeanDefinition registerHandlerMapping(ParserContext parserContext, Object source) {
        if (!parserContext.getRegistry().containsBeanDefinition(HANDLER_MAPPING_BEAN_NAME)) {
            RootBeanDefinition handlerMappingDef = new RootBeanDefinition(SimpleUrlHandlerMapping.class);
            handlerMappingDef.setSource(source);
            handlerMappingDef.getPropertyValues().add("order", "1");
            handlerMappingDef.setRole(2);
            parserContext.getRegistry().registerBeanDefinition(HANDLER_MAPPING_BEAN_NAME, handlerMappingDef);
            parserContext.registerComponent(new BeanComponentDefinition(handlerMappingDef, HANDLER_MAPPING_BEAN_NAME));
            return handlerMappingDef;
        }
        return parserContext.getRegistry().getBeanDefinition(HANDLER_MAPPING_BEAN_NAME);
    }
}

