/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.validation.beanvalidation;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.validation.Configuration;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.MessageInterpolator;
import javax.validation.TraversableResolver;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorContext;
import javax.validation.ValidatorFactory;
import org.hibernate.validator.messageinterpolation.ResourceBundleMessageInterpolator;
import org.hibernate.validator.spi.resourceloading.ResourceBundleLocator;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.MessageSource;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.validation.beanvalidation.LocaleContextMessageInterpolator;
import org.springframework.validation.beanvalidation.MessageSourceResourceBundleLocator;
import org.springframework.validation.beanvalidation.SpringConstraintValidatorFactory;
import org.springframework.validation.beanvalidation.SpringValidatorAdapter;

public class LocalValidatorFactoryBean
extends SpringValidatorAdapter
implements ValidatorFactory,
ApplicationContextAware,
InitializingBean,
DisposableBean {
    private static final Method closeMethod = ClassUtils.getMethodIfAvailable(ValidatorFactory.class, "close", new Class[0]);
    private Class providerClass;
    private MessageInterpolator messageInterpolator;
    private TraversableResolver traversableResolver;
    private ConstraintValidatorFactory constraintValidatorFactory;
    private ParameterNameDiscoverer parameterNameDiscoverer = new DefaultParameterNameDiscoverer();
    private Resource[] mappingLocations;
    private final Map<String, String> validationPropertyMap = new HashMap<String, String>();
    private ApplicationContext applicationContext;
    private ValidatorFactory validatorFactory;

    public void setProviderClass(Class providerClass) {
        this.providerClass = providerClass;
    }

    public void setMessageInterpolator(MessageInterpolator messageInterpolator) {
        this.messageInterpolator = messageInterpolator;
    }

    public void setValidationMessageSource(MessageSource messageSource) {
        this.messageInterpolator = HibernateValidatorDelegate.buildMessageInterpolator(messageSource);
    }

    public void setTraversableResolver(TraversableResolver traversableResolver) {
        this.traversableResolver = traversableResolver;
    }

    public void setConstraintValidatorFactory(ConstraintValidatorFactory constraintValidatorFactory) {
        this.constraintValidatorFactory = constraintValidatorFactory;
    }

    public void setParameterNameDiscoverer(ParameterNameDiscoverer parameterNameDiscoverer) {
        this.parameterNameDiscoverer = parameterNameDiscoverer;
    }

    public void setMappingLocations(Resource ... mappingLocations) {
        this.mappingLocations = mappingLocations;
    }

    public void setValidationProperties(Properties jpaProperties) {
        CollectionUtils.mergePropertiesIntoMap(jpaProperties, this.validationPropertyMap);
    }

    public void setValidationPropertyMap(Map<String, String> validationProperties) {
        if (validationProperties != null) {
            this.validationPropertyMap.putAll(validationProperties);
        }
    }

    public Map<String, String> getValidationPropertyMap() {
        return this.validationPropertyMap;
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Override
    public void afterPropertiesSet() {
        ConstraintValidatorFactory targetConstraintValidatorFactory;
        Configuration<?> configuration = this.providerClass != null ? Validation.byProvider(this.providerClass).configure() : Validation.byDefaultProvider().configure();
        MessageInterpolator targetInterpolator = this.messageInterpolator;
        if (targetInterpolator == null) {
            targetInterpolator = configuration.getDefaultMessageInterpolator();
        }
        configuration.messageInterpolator(new LocaleContextMessageInterpolator(targetInterpolator));
        if (this.traversableResolver != null) {
            configuration.traversableResolver(this.traversableResolver);
        }
        if ((targetConstraintValidatorFactory = this.constraintValidatorFactory) == null && this.applicationContext != null) {
            targetConstraintValidatorFactory = new SpringConstraintValidatorFactory(this.applicationContext.getAutowireCapableBeanFactory());
        }
        if (targetConstraintValidatorFactory != null) {
            configuration.constraintValidatorFactory(targetConstraintValidatorFactory);
        }
        if (this.parameterNameDiscoverer != null) {
            this.configureParameterNameProviderIfPossible(configuration);
        }
        if (this.mappingLocations != null) {
            for (Resource location : this.mappingLocations) {
                try {
                    configuration.addMapping(location.getInputStream());
                }
                catch (IOException ex) {
                    throw new IllegalStateException("Cannot read mapping resource: " + location);
                }
            }
        }
        for (Map.Entry entry : this.validationPropertyMap.entrySet()) {
            configuration.addProperty((String)entry.getKey(), (String)entry.getValue());
        }
        this.postProcessConfiguration(configuration);
        this.validatorFactory = configuration.buildValidatorFactory();
        this.setTargetValidator(this.validatorFactory.getValidator());
    }

    private void configureParameterNameProviderIfPossible(Configuration<?> configuration) {
        try {
            Class<?> parameterNameProviderClass = ClassUtils.forName("javax.validation.ParameterNameProvider", this.getClass().getClassLoader());
            Method parameterNameProviderMethod = Configuration.class.getMethod("parameterNameProvider", parameterNameProviderClass);
            final Object defaultProvider = ReflectionUtils.invokeMethod(Configuration.class.getMethod("getDefaultParameterNameProvider", new Class[0]), configuration);
            final ParameterNameDiscoverer discoverer = this.parameterNameDiscoverer;
            Object parameterNameProvider = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{parameterNameProviderClass}, new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    if (method.getName().equals("getParameterNames")) {
                        String[] result = null;
                        if (args[0] instanceof Constructor) {
                            result = discoverer.getParameterNames((Constructor)args[0]);
                        } else if (args[0] instanceof Method) {
                            result = discoverer.getParameterNames((Method)args[0]);
                        }
                        if (result != null) {
                            return Arrays.asList(result);
                        }
                        try {
                            return method.invoke(defaultProvider, args);
                        }
                        catch (InvocationTargetException ex) {
                            throw ex.getTargetException();
                        }
                    }
                    try {
                        return method.invoke((Object)this, args);
                    }
                    catch (InvocationTargetException ex) {
                        throw ex.getTargetException();
                    }
                }
            });
            ReflectionUtils.invokeMethod(parameterNameProviderMethod, configuration, parameterNameProvider);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void postProcessConfiguration(Configuration<?> configuration) {
    }

    @Override
    public Validator getValidator() {
        Assert.notNull(this.validatorFactory, "No target ValidatorFactory set");
        return this.validatorFactory.getValidator();
    }

    @Override
    public ValidatorContext usingContext() {
        Assert.notNull(this.validatorFactory, "No target ValidatorFactory set");
        return this.validatorFactory.usingContext();
    }

    @Override
    public MessageInterpolator getMessageInterpolator() {
        Assert.notNull(this.validatorFactory, "No target ValidatorFactory set");
        return this.validatorFactory.getMessageInterpolator();
    }

    @Override
    public TraversableResolver getTraversableResolver() {
        Assert.notNull(this.validatorFactory, "No target ValidatorFactory set");
        return this.validatorFactory.getTraversableResolver();
    }

    @Override
    public ConstraintValidatorFactory getConstraintValidatorFactory() {
        Assert.notNull(this.validatorFactory, "No target ValidatorFactory set");
        return this.validatorFactory.getConstraintValidatorFactory();
    }

    public void close() {
        if (closeMethod != null && this.validatorFactory != null) {
            ReflectionUtils.invokeMethod(closeMethod, this.validatorFactory);
        }
    }

    @Override
    public void destroy() {
        this.close();
    }

    private static class HibernateValidatorDelegate {
        private HibernateValidatorDelegate() {
        }

        public static MessageInterpolator buildMessageInterpolator(MessageSource messageSource) {
            return new ResourceBundleMessageInterpolator((ResourceBundleLocator)new MessageSourceResourceBundleLocator(messageSource));
        }
    }
}

