/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.quartz;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.StatefulJob;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.support.ArgumentConvertingMethodInvoker;
import org.springframework.scheduling.quartz.JobMethodInvocationFailedException;
import org.springframework.scheduling.quartz.QuartzJobBean;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.MethodInvoker;
import org.springframework.util.ReflectionUtils;

public class MethodInvokingJobDetailFactoryBean
extends ArgumentConvertingMethodInvoker
implements FactoryBean<JobDetail>,
BeanNameAware,
BeanClassLoaderAware,
BeanFactoryAware,
InitializingBean {
    private static Class<?> jobDetailImplClass;
    private static Method setResultMethod;
    private String name;
    private String group = "DEFAULT";
    private boolean concurrent = true;
    private String targetBeanName;
    private String[] jobListenerNames;
    private String beanName;
    private ClassLoader beanClassLoader = ClassUtils.getDefaultClassLoader();
    private BeanFactory beanFactory;
    private JobDetail jobDetail;

    public void setName(String name) {
        this.name = name;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public void setConcurrent(boolean concurrent) {
        this.concurrent = concurrent;
    }

    public void setTargetBeanName(String targetBeanName) {
        this.targetBeanName = targetBeanName;
    }

    @Deprecated
    public void setJobListenerNames(String ... names) {
        this.jobListenerNames = names;
    }

    @Override
    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    @Override
    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    @Override
    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    @Override
    protected Class<?> resolveClassName(String className) throws ClassNotFoundException {
        return ClassUtils.forName(className, this.beanClassLoader);
    }

    @Override
    public void afterPropertiesSet() throws ClassNotFoundException, NoSuchMethodException {
        Class jobClass;
        this.prepare();
        String name = this.name != null ? this.name : this.beanName;
        Class clazz = jobClass = this.concurrent ? MethodInvokingJob.class : StatefulMethodInvokingJob.class;
        if (jobDetailImplClass != null) {
            this.jobDetail = (JobDetail)BeanUtils.instantiate(jobDetailImplClass);
            BeanWrapper bw = PropertyAccessorFactory.forBeanPropertyAccess(this.jobDetail);
            bw.setPropertyValue("name", name);
            bw.setPropertyValue("group", this.group);
            bw.setPropertyValue("jobClass", jobClass);
            bw.setPropertyValue("durability", true);
            ((JobDataMap)bw.getPropertyValue("jobDataMap")).put((Object)"methodInvoker", (Object)this);
        } else {
            this.jobDetail = new JobDetail(name, this.group, jobClass);
            this.jobDetail.setVolatility(true);
            this.jobDetail.setDurability(true);
            this.jobDetail.getJobDataMap().put((Object)"methodInvoker", (Object)this);
        }
        if (this.jobListenerNames != null) {
            for (String jobListenerName : this.jobListenerNames) {
                if (jobDetailImplClass != null) {
                    throw new IllegalStateException("Non-global JobListeners not supported on Quartz 2 - manually register a Matcher against the Quartz ListenerManager instead");
                }
                this.jobDetail.addJobListener(jobListenerName);
            }
        }
        this.postProcessJobDetail(this.jobDetail);
    }

    protected void postProcessJobDetail(JobDetail jobDetail) {
    }

    @Override
    public Class<?> getTargetClass() {
        Class<?> targetClass = super.getTargetClass();
        if (targetClass == null && this.targetBeanName != null) {
            Assert.state(this.beanFactory != null, "BeanFactory must be set when using 'targetBeanName'");
            targetClass = this.beanFactory.getType(this.targetBeanName);
        }
        return targetClass;
    }

    @Override
    public Object getTargetObject() {
        Object targetObject = super.getTargetObject();
        if (targetObject == null && this.targetBeanName != null) {
            Assert.state(this.beanFactory != null, "BeanFactory must be set when using 'targetBeanName'");
            targetObject = this.beanFactory.getBean(this.targetBeanName);
        }
        return targetObject;
    }

    @Override
    public JobDetail getObject() {
        return this.jobDetail;
    }

    @Override
    public Class<? extends JobDetail> getObjectType() {
        return this.jobDetail != null ? this.jobDetail.getClass() : JobDetail.class;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    static {
        try {
            jobDetailImplClass = ClassUtils.forName("org.quartz.impl.JobDetailImpl", MethodInvokingJobDetailFactoryBean.class.getClassLoader());
        }
        catch (ClassNotFoundException ex) {
            jobDetailImplClass = null;
        }
        try {
            Class<?> jobExecutionContextClass = ClassUtils.forName("org.quartz.JobExecutionContext", MethodInvokingJobDetailFactoryBean.class.getClassLoader());
            setResultMethod = jobExecutionContextClass.getMethod("setResult", Object.class);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Incompatible Quartz API: " + ex);
        }
    }

    public static class StatefulMethodInvokingJob
    extends MethodInvokingJob
    implements StatefulJob {
    }

    public static class MethodInvokingJob
    extends QuartzJobBean {
        protected static final Log logger = LogFactory.getLog(MethodInvokingJob.class);
        private MethodInvoker methodInvoker;

        public void setMethodInvoker(MethodInvoker methodInvoker) {
            this.methodInvoker = methodInvoker;
        }

        @Override
        protected void executeInternal(JobExecutionContext context) throws JobExecutionException {
            try {
                ReflectionUtils.invokeMethod(setResultMethod, context, this.methodInvoker.invoke());
            }
            catch (InvocationTargetException ex) {
                if (ex.getTargetException() instanceof JobExecutionException) {
                    throw (JobExecutionException)ex.getTargetException();
                }
                throw new JobMethodInvocationFailedException(this.methodInvoker, ex.getTargetException());
            }
            catch (Exception ex) {
                throw new JobMethodInvocationFailedException(this.methodInvoker, (Throwable)ex);
            }
        }
    }
}

