/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.listener.endpoint;

import javax.jms.MessageListener;
import javax.resource.ResourceException;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.jca.endpoint.GenericMessageEndpointManager;
import org.springframework.jms.listener.endpoint.DefaultJmsActivationSpecFactory;
import org.springframework.jms.listener.endpoint.JmsActivationSpecConfig;
import org.springframework.jms.listener.endpoint.JmsActivationSpecFactory;
import org.springframework.jms.listener.endpoint.JmsMessageEndpointFactory;
import org.springframework.jms.support.destination.DestinationResolver;

public class JmsMessageEndpointManager
extends GenericMessageEndpointManager
implements BeanNameAware {
    private final JmsMessageEndpointFactory endpointFactory = new JmsMessageEndpointFactory();
    private boolean messageListenerSet = false;
    private JmsActivationSpecFactory activationSpecFactory = new DefaultJmsActivationSpecFactory();
    private JmsActivationSpecConfig activationSpecConfig;

    public void setMessageListener(MessageListener messageListener) {
        this.endpointFactory.setMessageListener(messageListener);
        this.messageListenerSet = true;
    }

    public void setTransactionManager(Object transactionManager) {
        this.endpointFactory.setTransactionManager(transactionManager);
    }

    public void setActivationSpecFactory(JmsActivationSpecFactory activationSpecFactory) {
        this.activationSpecFactory = activationSpecFactory != null ? activationSpecFactory : new DefaultJmsActivationSpecFactory();
    }

    public void setDestinationResolver(DestinationResolver destinationResolver) {
        DefaultJmsActivationSpecFactory factory = new DefaultJmsActivationSpecFactory();
        factory.setDestinationResolver(destinationResolver);
        this.activationSpecFactory = factory;
    }

    public void setActivationSpecConfig(JmsActivationSpecConfig activationSpecConfig) {
        this.activationSpecConfig = activationSpecConfig;
    }

    @Override
    public void setBeanName(String beanName) {
        this.endpointFactory.setBeanName(beanName);
    }

    @Override
    public void afterPropertiesSet() throws ResourceException {
        if (this.messageListenerSet) {
            this.setMessageEndpointFactory(this.endpointFactory);
        }
        if (this.activationSpecConfig != null) {
            this.setActivationSpec(this.activationSpecFactory.createActivationSpec(this.getResourceAdapter(), this.activationSpecConfig));
        }
        super.afterPropertiesSet();
    }
}

