/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.config;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.jms.config.AbstractListenerContainerParser;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

class JmsListenerContainerParser
extends AbstractListenerContainerParser {
    private static final String CONTAINER_TYPE_ATTRIBUTE = "container-type";
    private static final String CONTAINER_CLASS_ATTRIBUTE = "container-class";
    private static final String CONNECTION_FACTORY_ATTRIBUTE = "connection-factory";
    private static final String TASK_EXECUTOR_ATTRIBUTE = "task-executor";
    private static final String ERROR_HANDLER_ATTRIBUTE = "error-handler";
    private static final String CACHE_ATTRIBUTE = "cache";
    private static final String RECEIVE_TIMEOUT_ATTRIBUTE = "receive-timeout";
    private static final String RECOVERY_INTERVAL_ATTRIBUTE = "recovery-interval";

    JmsListenerContainerParser() {
    }

    @Override
    protected BeanDefinition parseContainer(Element listenerEle, Element containerEle, ParserContext parserContext) {
        String phase;
        String recoveryInterval;
        String receiveTimeout;
        String prefetch;
        String concurrency;
        String transactionManagerBeanName;
        Integer acknowledgeMode;
        String cache;
        String destinationResolverBeanName;
        String errorHandlerBeanName;
        String taskExecutorBeanName;
        RootBeanDefinition containerDef = new RootBeanDefinition();
        containerDef.setSource(parserContext.extractSource(containerEle));
        this.parseListenerConfiguration(listenerEle, parserContext, containerDef);
        this.parseContainerConfiguration(containerEle, parserContext, containerDef);
        String containerType = containerEle.getAttribute(CONTAINER_TYPE_ATTRIBUTE);
        String containerClass = containerEle.getAttribute(CONTAINER_CLASS_ATTRIBUTE);
        if (!"".equals(containerClass)) {
            containerDef.setBeanClassName(containerClass);
        } else if ("".equals(containerType) || containerType.startsWith("default")) {
            containerDef.setBeanClassName("org.springframework.jms.listener.DefaultMessageListenerContainer");
        } else if (containerType.startsWith("simple")) {
            containerDef.setBeanClassName("org.springframework.jms.listener.SimpleMessageListenerContainer");
        } else {
            parserContext.getReaderContext().error("Invalid 'container-type' attribute: only \"default\" and \"simple\" supported.", containerEle);
        }
        String connectionFactoryBeanName = "connectionFactory";
        if (containerEle.hasAttribute(CONNECTION_FACTORY_ATTRIBUTE) && !StringUtils.hasText(connectionFactoryBeanName = containerEle.getAttribute(CONNECTION_FACTORY_ATTRIBUTE))) {
            parserContext.getReaderContext().error("Listener container 'connection-factory' attribute contains empty value.", containerEle);
        }
        if (StringUtils.hasText(connectionFactoryBeanName)) {
            containerDef.getPropertyValues().add("connectionFactory", new RuntimeBeanReference(connectionFactoryBeanName));
        }
        if (StringUtils.hasText(taskExecutorBeanName = containerEle.getAttribute(TASK_EXECUTOR_ATTRIBUTE))) {
            containerDef.getPropertyValues().add("taskExecutor", new RuntimeBeanReference(taskExecutorBeanName));
        }
        if (StringUtils.hasText(errorHandlerBeanName = containerEle.getAttribute(ERROR_HANDLER_ATTRIBUTE))) {
            containerDef.getPropertyValues().add("errorHandler", new RuntimeBeanReference(errorHandlerBeanName));
        }
        if (StringUtils.hasText(destinationResolverBeanName = containerEle.getAttribute("destination-resolver"))) {
            containerDef.getPropertyValues().add("destinationResolver", new RuntimeBeanReference(destinationResolverBeanName));
        }
        if (StringUtils.hasText(cache = containerEle.getAttribute(CACHE_ATTRIBUTE))) {
            if (containerType.startsWith("simple")) {
                if (!"auto".equals(cache) && !"consumer".equals(cache)) {
                    parserContext.getReaderContext().warning("'cache' attribute not actively supported for listener container of type \"simple\". Effective runtime behavior will be equivalent to \"consumer\" / \"auto\".", containerEle);
                }
            } else {
                containerDef.getPropertyValues().add("cacheLevelName", "CACHE_" + cache.toUpperCase());
            }
        }
        if ((acknowledgeMode = this.parseAcknowledgeMode(containerEle, parserContext)) != null) {
            if (acknowledgeMode == 0) {
                containerDef.getPropertyValues().add("sessionTransacted", Boolean.TRUE);
            } else {
                containerDef.getPropertyValues().add("sessionAcknowledgeMode", acknowledgeMode);
            }
        }
        if (StringUtils.hasText(transactionManagerBeanName = containerEle.getAttribute("transaction-manager"))) {
            if (containerType.startsWith("simple")) {
                parserContext.getReaderContext().error("'transaction-manager' attribute not supported for listener container of type \"simple\".", containerEle);
            } else {
                containerDef.getPropertyValues().add("transactionManager", new RuntimeBeanReference(transactionManagerBeanName));
            }
        }
        if (StringUtils.hasText(concurrency = containerEle.getAttribute("concurrency"))) {
            containerDef.getPropertyValues().add("concurrency", concurrency);
        }
        if (StringUtils.hasText(prefetch = containerEle.getAttribute("prefetch")) && containerType.startsWith("default")) {
            containerDef.getPropertyValues().add("maxMessagesPerTask", prefetch);
        }
        if (StringUtils.hasText(receiveTimeout = containerEle.getAttribute(RECEIVE_TIMEOUT_ATTRIBUTE)) && containerType.startsWith("default")) {
            containerDef.getPropertyValues().add("receiveTimeout", receiveTimeout);
        }
        if (StringUtils.hasText(recoveryInterval = containerEle.getAttribute(RECOVERY_INTERVAL_ATTRIBUTE)) && containerType.startsWith("default")) {
            containerDef.getPropertyValues().add("recoveryInterval", recoveryInterval);
        }
        if (StringUtils.hasText(phase = containerEle.getAttribute("phase"))) {
            containerDef.getPropertyValues().add("phase", phase);
        }
        return containerDef;
    }

    @Override
    protected boolean indicatesPubSub(BeanDefinition containerDef) {
        return this.indicatesPubSubConfig(containerDef);
    }
}

