/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.expression.support;

import org.springframework.binding.expression.EvaluationException;
import org.springframework.binding.expression.Expression;
import org.springframework.util.Assert;

public class LiteralExpression
implements Expression {
    private String literal;

    public LiteralExpression(String literal) {
        Assert.notNull(literal, "The literal is required");
        this.literal = literal;
    }

    public int hashCode() {
        return this.literal.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof LiteralExpression)) {
            return false;
        }
        LiteralExpression other = (LiteralExpression)o;
        return this.literal.equals(other.literal);
    }

    public Object getValue(Object context) throws EvaluationException {
        return this.literal;
    }

    public void setValue(Object context, Object value) throws EvaluationException {
        throw new UnsupportedOperationException("Cannot set a literal expression value.  Are you attempting to set a property expression?  If so, should the expression string be enclosed in eval delimiters?");
    }

    public Class getValueType(Object context) {
        return String.class;
    }

    public String getExpressionString() {
        return null;
    }

    public String toString() {
        return this.literal;
    }
}

