/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.framework;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.framework.AdvisedSupport;
import org.springframework.aop.framework.CglibAopProxy;
import org.springframework.cglib.proxy.Callback;
import org.springframework.cglib.proxy.Enhancer;
import org.springframework.cglib.proxy.Factory;
import org.springframework.objenesis.ObjenesisException;
import org.springframework.objenesis.ObjenesisStd;

class ObjenesisCglibAopProxy
extends CglibAopProxy {
    private static final Log logger = LogFactory.getLog(ObjenesisCglibAopProxy.class);
    private final ObjenesisStd objenesis = new ObjenesisStd(true);

    public ObjenesisCglibAopProxy(AdvisedSupport config) {
        super(config);
    }

    @Override
    protected Object createProxyClassAndInstance(Enhancer enhancer, Callback[] callbacks) {
        try {
            Factory factory = (Factory)this.objenesis.newInstance(enhancer.createClass());
            factory.setCallbacks(callbacks);
            return factory;
        }
        catch (ObjenesisException ex) {
            if (logger.isDebugEnabled()) {
                logger.debug("Unable to instantiate proxy using Objenesis, falling back to regular proxy construction", ex);
            }
            return super.createProxyClassAndInstance(enhancer, callbacks);
        }
    }
}

