/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.ticketer.jira;

import com.atlassian.jira.rest.client.JiraRestClient;
import com.atlassian.jira.rest.client.JiraRestClientFactory;
import com.atlassian.jira.rest.client.NullProgressMonitor;
import com.atlassian.jira.rest.client.ProgressMonitor;
import com.atlassian.jira.rest.client.auth.AnonymousAuthenticationHandler;
import com.atlassian.jira.rest.client.domain.BasicIssue;
import com.atlassian.jira.rest.client.domain.Comment;
import com.atlassian.jira.rest.client.domain.Issue;
import com.atlassian.jira.rest.client.domain.Transition;
import com.atlassian.jira.rest.client.domain.input.IssueInputBuilder;
import com.atlassian.jira.rest.client.domain.input.TransitionInput;
import com.atlassian.jira.rest.client.internal.jersey.JerseyJiraRestClientFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Calendar;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.joda.time.DateTime;
import org.opennms.api.integration.ticketing.Plugin;
import org.opennms.api.integration.ticketing.Ticket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraTicketerPlugin
implements Plugin {
    private static final Logger LOG = LoggerFactory.getLogger(JiraTicketerPlugin.class);
    protected final JiraRestClientFactory clientFactory = new JerseyJiraRestClientFactory();

    protected JiraRestClient getConnection() {
        try {
            URI jiraUri = new URL(JiraTicketerPlugin.getProperties().getProperty("jira.host")).toURI();
            String username = JiraTicketerPlugin.getProperties().getProperty("jira.username");
            if (username == null || "".equals(username)) {
                return this.clientFactory.create(jiraUri, new AnonymousAuthenticationHandler());
            }
            return this.clientFactory.createWithBasicHttpAuthentication(jiraUri, JiraTicketerPlugin.getProperties().getProperty("jira.username"), JiraTicketerPlugin.getProperties().getProperty("jira.password"));
        }
        catch (MalformedURLException e) {
            LOG.error("Failed to parse URL: {}", (Object)JiraTicketerPlugin.getProperties().getProperty("jira.host"));
        }
        catch (URISyntaxException e) {
            LOG.error("Failed to parse URI: {}", (Object)JiraTicketerPlugin.getProperties().getProperty("jira.host"));
        }
        return null;
    }

    @Override
    public Ticket get(String ticketId) {
        JiraRestClient jira = this.getConnection();
        if (jira == null) {
            return null;
        }
        Issue issue = jira.getIssueClient().getIssue(ticketId, new NullProgressMonitor());
        if (issue != null) {
            Ticket ticket = new Ticket();
            ticket.setId(issue.getKey());
            ticket.setModificationTimestamp(String.valueOf(issue.getUpdateDate().toDate().getTime()));
            ticket.setSummary(issue.getSummary());
            String allComments = "";
            for (Comment comment : issue.getComments()) {
                allComments = allComments + "\n" + comment.getAuthor().getDisplayName() + "\n" + comment.getBody();
            }
            ticket.setDetails(allComments.trim());
            ticket.setState(JiraTicketerPlugin.getStateFromId(issue.getStatus().getName()));
            return ticket;
        }
        return null;
    }

    private static Ticket.State getStateFromId(String stateIdString) {
        if (stateIdString == null) {
            return Ticket.State.OPEN;
        }
        if ("Open".equals(stateIdString)) {
            return Ticket.State.OPEN;
        }
        if ("In Progress".equals(stateIdString)) {
            return Ticket.State.OPEN;
        }
        if ("Reopened".equals(stateIdString)) {
            return Ticket.State.OPEN;
        }
        if ("Resolved".equals(stateIdString)) {
            return Ticket.State.CLOSED;
        }
        if ("Closed".equals(stateIdString)) {
            return Ticket.State.CLOSED;
        }
        return Ticket.State.OPEN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties getProperties() {
        File home = new File(System.getProperty("opennms.home"));
        File etc = new File(home, "etc");
        File config = new File(etc, "jira.properties");
        Properties props = new Properties();
        FileInputStream in = null;
        try {
            in = new FileInputStream(config);
            props.load(in);
        }
        catch (IOException e) {
            try {
                LOG.error("Unable to load {} ignoring.", (Object)config, (Object)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
            IOUtils.closeQuietly(in);
        }
        IOUtils.closeQuietly(in);
        LOG.debug("Loaded user: {}", (Object)props.getProperty("jira.username"));
        LOG.debug("Loaded type: {}", (Object)props.getProperty("jira.type"));
        return props;
    }

    @Override
    public void saveOrUpdate(Ticket ticket) {
        JiraRestClient jira = this.getConnection();
        if (ticket.getId() == null || ticket.getId().equals("")) {
            IssueInputBuilder builder = new IssueInputBuilder(JiraTicketerPlugin.getProperties().getProperty("jira.project"), Long.valueOf(JiraTicketerPlugin.getProperties().getProperty("jira.type").trim()));
            builder.setReporterName(JiraTicketerPlugin.getProperties().getProperty("jira.username"));
            builder.setSummary(ticket.getSummary());
            builder.setDescription(ticket.getDetails());
            builder.setDueDate(new DateTime(Calendar.getInstance()));
            BasicIssue createdIssue = jira.getIssueClient().createIssue(builder.build(), new NullProgressMonitor());
            LOG.info("created ticket " + createdIssue);
            ticket.setId(createdIssue.getKey());
        } else {
            LOG.info("Received ticket: {}", (Object)ticket.getId());
            Issue issue = jira.getIssueClient().getIssue(ticket.getId(), new NullProgressMonitor());
            Iterable<Transition> transitions = jira.getIssueClient().getTransitions(issue, (ProgressMonitor)new NullProgressMonitor());
            if (Ticket.State.CLOSED.equals((Object)ticket.getState())) {
                Comment comment = Comment.valueOf("Issue resolved by OpenNMS.");
                for (Transition transition : transitions) {
                    if (!"Resolve Issue".equals(transition.getName())) continue;
                    LOG.info("Resolving ticket {}", (Object)ticket.getId());
                    jira.getIssueClient().transition(issue, new TransitionInput(transition.getId(), comment), (ProgressMonitor)new NullProgressMonitor());
                    return;
                }
                LOG.warn("Could not resolve ticket {}, no \"Resolve Issue\" operation available.", (Object)ticket.getId());
            } else if (Ticket.State.OPEN.equals((Object)ticket.getState())) {
                Comment comment = Comment.valueOf("Issue reopened by OpenNMS.");
                for (Transition transition : transitions) {
                    if (!"Reopen Issue".equals(transition.getName())) continue;
                    LOG.info("Reopening ticket {}", (Object)ticket.getId());
                    jira.getIssueClient().transition(issue, new TransitionInput(transition.getId(), comment), (ProgressMonitor)new NullProgressMonitor());
                    return;
                }
                LOG.warn("Could not reopen ticket {}, no \"Reopen Issue\" operation available.", (Object)ticket.getId());
            }
        }
    }
}

