/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.utils;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamGobbler
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(StreamGobbler.class);
    private InputStream in = null;
    private PrintWriter pwOut = null;
    private boolean quit = false;

    public StreamGobbler() {
    }

    public StreamGobbler(InputStream in) {
        this();
        this.in = in;
        this.pwOut = new PrintWriter(System.out, true);
    }

    public StreamGobbler(InputStream in, OutputStream out) {
        this();
        this.in = in;
        this.pwOut = new PrintWriter(out, true);
    }

    public StreamGobbler(InputStream in, PrintWriter pwOut) {
        this();
        this.in = in;
        this.pwOut = pwOut;
    }

    @Override
    public final Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public void quit() {
        this.quit = true;
    }

    private final void readObject(ObjectInputStream in) throws IOException {
        throw new IOException("Object cannot be deserialized");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        InputStreamReader isr = null;
        BufferedReader br = null;
        try {
            isr = new InputStreamReader(this.in);
            br = new BufferedReader(isr);
            String line = null;
            while ((line = br.readLine()) != null && !this.quit) {
                this.pwOut.println(line);
            }
            this.closeQuietly(br);
            this.closeQuietly(isr);
        }
        catch (Throwable e) {
            try {
                LOG.debug("Unable to read lines.", e);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                this.closeQuietly(br);
                this.closeQuietly(isr);
            }
        }
    }

    private final void writeObject(ObjectOutputStream out) throws IOException {
        throw new IOException("Object cannot be serialized");
    }

    private void closeQuietly(Closeable c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (IOException closeE) {
                LOG.debug("failed to close", closeE);
            }
        }
    }
}

