/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.utils;

import java.util.HashMap;
import java.util.Map;
import org.opennms.core.network.IPAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LldpUtils {
    private static final Logger LOG = LoggerFactory.getLogger(LldpUtils.class);

    public static String decodeNetworkAddress(String networkAddress) {
        IanaAddressFamilyNumber type = IanaAddressFamilyNumber.get(LldpUtils.IanaFamilyAddressStringToType(networkAddress));
        switch (type) {
            case IANA_ADDRESS_FAMILY_IP: 
            case IANA_ADDRESS_FAMILY_IP6: {
                return new IPAddress(LldpUtils.IanaFamilyAddressStringToBytes(networkAddress)).toDbString();
            }
        }
        return IanaAddressFamilyNumber.getTypeString(type.getValue()) + ": " + "type=" + type.getValue() + " address=" + networkAddress.substring(networkAddress.indexOf(":"));
    }

    public static Integer IanaFamilyAddressStringToType(String networkAddress) {
        if (networkAddress == null) {
            throw new IllegalArgumentException("Cannot decode null IANA Family address");
        }
        try {
            return Integer.decode("0x" + networkAddress.split(":")[0]);
        }
        catch (NumberFormatException e) {
            String message = "Cannot decode invalid IANA Family address: " + networkAddress;
            LOG.debug(message, e);
            throw new IllegalArgumentException(message, e);
        }
    }

    public static byte[] IanaFamilyAddressStringToBytes(String networkAddress) {
        if (networkAddress == null) {
            throw new IllegalArgumentException("Cannot decode null IANA Family address");
        }
        String[] digits = networkAddress.split(":");
        byte[] contents = new byte[digits.length - 1];
        for (int i = 1; i < digits.length; ++i) {
            try {
                contents[i - 1] = Integer.decode("0x" + digits[i]).byteValue();
                continue;
            }
            catch (NumberFormatException e) {
                String message = "Cannot decode invalid IANA Family address: " + networkAddress;
                LOG.debug(message, e);
                throw new IllegalArgumentException(message, e);
            }
        }
        return contents;
    }

    public static enum IanaAddressFamilyNumber {
        IANA_ADDRESS_FAMILY_Reserved(0),
        IANA_ADDRESS_FAMILY_IP(1),
        IANA_ADDRESS_FAMILY_IP6(2),
        IANA_ADDRESS_FAMILY_NSAP(3),
        IANA_ADDRESS_FAMILY_HDLC(4),
        IANA_ADDRESS_FAMILY_BBN(5),
        IANA_ADDRESS_FAMILY_802(6),
        IANA_ADDRESS_FAMILY_E_163(7),
        IANA_ADDRESS_FAMILY_E_164(8),
        IANA_ADDRESS_FAMILY_F_69(9),
        IANA_ADDRESS_FAMILY_X_121(10),
        IANA_ADDRESS_FAMILY_IPX(11),
        IANA_ADDRESS_FAMILY_Appletalk(12),
        IANA_ADDRESS_FAMILY_Decnet(13),
        IANA_ADDRESS_FAMILY_Banyan(14),
        IANA_ADDRESS_FAMILY_E_164_NSAP(15),
        IANA_ADDRESS_FAMILY_DNS(16),
        IANA_ADDRESS_FAMILY_Distinguished(17),
        IANA_ADDRESS_FAMILY_AS(18),
        IANA_ADDRESS_FAMILY_XTP_IP(19),
        IANA_ADDRESS_FAMILY_XTP_IPv6(20),
        IANA_ADDRESS_FAMILY_XTP(21),
        IANA_ADDRESS_FAMILY_FibreChannel_World_Wide_Port_Name(22),
        IANA_ADDRESS_FAMILY_FibreChannel_World_Wide_Node_Name(23),
        IANA_ADDRESS_FAMILY_GWID(24),
        IANA_ADDRESS_FAMILY_AFI(25),
        IANA_ADDRESS_FAMILY_MPLS_TP_Section_Endpoint_Identifier(26),
        IANA_ADDRESS_FAMILY_MPLS_TP_LSP_Endpoint_Identifier(27),
        IANA_ADDRESS_FAMILY_MPLS_Pseudowire_Section_Endpoint_Identifier(28),
        IANA_ADDRESS_FAMILY_MT_IP(29),
        IANA_ADDRESS_FAMILY_MT_IPv6(30),
        IANA_ADDRESS_FAMILY_Unassigned(31);

        private int m_type;
        protected static final Map<Integer, String> s_typeMap;

        public Integer getValue() {
            return this.m_type;
        }

        private IanaAddressFamilyNumber(Integer ianaAddressFamilyNumber) {
            this.m_type = ianaAddressFamilyNumber;
        }

        public static String getTypeString(Integer code) {
            if (s_typeMap.containsKey(code)) {
                return s_typeMap.get(code);
            }
            return null;
        }

        public static IanaAddressFamilyNumber get(Integer code) {
            if (code == null) {
                throw new IllegalArgumentException("Cannot create IanaAddressFamilyNumber from null code");
            }
            switch (code) {
                case 0: {
                    return IANA_ADDRESS_FAMILY_Reserved;
                }
                case 1: {
                    return IANA_ADDRESS_FAMILY_IP;
                }
                case 2: {
                    return IANA_ADDRESS_FAMILY_IP6;
                }
                case 3: {
                    return IANA_ADDRESS_FAMILY_NSAP;
                }
                case 4: {
                    return IANA_ADDRESS_FAMILY_HDLC;
                }
                case 5: {
                    return IANA_ADDRESS_FAMILY_BBN;
                }
                case 6: {
                    return IANA_ADDRESS_FAMILY_802;
                }
                case 7: {
                    return IANA_ADDRESS_FAMILY_E_163;
                }
                case 8: {
                    return IANA_ADDRESS_FAMILY_E_164;
                }
                case 9: {
                    return IANA_ADDRESS_FAMILY_F_69;
                }
                case 10: {
                    return IANA_ADDRESS_FAMILY_X_121;
                }
                case 11: {
                    return IANA_ADDRESS_FAMILY_IPX;
                }
                case 12: {
                    return IANA_ADDRESS_FAMILY_Appletalk;
                }
                case 13: {
                    return IANA_ADDRESS_FAMILY_Decnet;
                }
                case 14: {
                    return IANA_ADDRESS_FAMILY_Banyan;
                }
                case 15: {
                    return IANA_ADDRESS_FAMILY_E_164_NSAP;
                }
                case 16: {
                    return IANA_ADDRESS_FAMILY_DNS;
                }
                case 17: {
                    return IANA_ADDRESS_FAMILY_Distinguished;
                }
                case 18: {
                    return IANA_ADDRESS_FAMILY_AS;
                }
                case 19: {
                    return IANA_ADDRESS_FAMILY_XTP_IP;
                }
                case 20: {
                    return IANA_ADDRESS_FAMILY_XTP_IPv6;
                }
                case 21: {
                    return IANA_ADDRESS_FAMILY_XTP;
                }
                case 22: {
                    return IANA_ADDRESS_FAMILY_FibreChannel_World_Wide_Port_Name;
                }
                case 23: {
                    return IANA_ADDRESS_FAMILY_FibreChannel_World_Wide_Node_Name;
                }
                case 24: {
                    return IANA_ADDRESS_FAMILY_GWID;
                }
                case 25: {
                    return IANA_ADDRESS_FAMILY_AFI;
                }
                case 26: {
                    return IANA_ADDRESS_FAMILY_MPLS_TP_Section_Endpoint_Identifier;
                }
                case 27: {
                    return IANA_ADDRESS_FAMILY_MPLS_TP_LSP_Endpoint_Identifier;
                }
                case 28: {
                    return IANA_ADDRESS_FAMILY_MPLS_Pseudowire_Section_Endpoint_Identifier;
                }
                case 29: {
                    return IANA_ADDRESS_FAMILY_MT_IP;
                }
                case 30: {
                    return IANA_ADDRESS_FAMILY_MT_IPv6;
                }
                case 31: {
                    return IANA_ADDRESS_FAMILY_Unassigned;
                }
            }
            throw new IllegalArgumentException("Cannot create IanaAddressFamilyNumber from code " + code);
        }

        static {
            s_typeMap = new HashMap<Integer, String>();
            s_typeMap.put(0, "Reserved");
            s_typeMap.put(1, "IP (IP version 4)");
            s_typeMap.put(2, "IP6 (IP version 6)");
            s_typeMap.put(3, "NSAP");
            s_typeMap.put(4, "HDLC (8-bit multidrop)");
            s_typeMap.put(5, "BBN 1822");
            s_typeMap.put(6, "802 (includes all 802 media plus Ethernet \"canonical format\")");
            s_typeMap.put(7, "E.163");
            s_typeMap.put(8, "E.164 (SMDS, Frame Relay, ATM)");
            s_typeMap.put(9, "F.69 (Telex)");
            s_typeMap.put(10, "X.121 (X.25, Frame Relay)");
            s_typeMap.put(11, "IPX");
            s_typeMap.put(12, "Appletalk");
            s_typeMap.put(13, "Decnet IV");
            s_typeMap.put(14, "Banyan Vines");
            s_typeMap.put(15, "E.164 with NSAP format subaddress");
            s_typeMap.put(16, "DNS (Domain Name System)");
            s_typeMap.put(17, "Distinguished Name");
            s_typeMap.put(18, "AS Number");
            s_typeMap.put(19, "XTP over IP version 4");
            s_typeMap.put(20, "XTP over IP version 6");
            s_typeMap.put(21, "XTP native mode XTP");
            s_typeMap.put(22, "Fibre Channel World-Wide Port Name");
            s_typeMap.put(23, "Fibre Channel World-Wide Node Name");
            s_typeMap.put(24, "GWID");
            s_typeMap.put(25, "AFI for L2VPN information");
            s_typeMap.put(26, "MPLS-TP Section Endpoint Identifier");
            s_typeMap.put(27, "MPLS-TP LSP Endpoint Identifier");
            s_typeMap.put(28, "MPLS-TP Pseudowire Endpoint Identifier");
            s_typeMap.put(29, "MT IP: Multi-Topology IP version 4");
            s_typeMap.put(30, "MT IPv6: Multi-Topology IP version 6");
            s_typeMap.put(31, "Unassigned");
        }
    }

    public static enum LldpPortIdSubType {
        LLDP_PORTID_SUBTYPE_INTERFACEALIAS(1),
        LLDP_PORTID_SUBTYPE_PORTCOMPONENT(2),
        LLDP_PORTID_SUBTYPE_MACADDRESS(3),
        LLDP_PORTID_SUBTYPE_NETWORKADDRESS(4),
        LLDP_PORTID_SUBTYPE_INTERFACENAME(5),
        LLDP_PORTID_SUBTYPE_AGENTCIRCUITID(6),
        LLDP_PORTID_SUBTYPE_LOCAL(7);

        private int m_type;
        protected static final Map<Integer, String> s_typeMap;

        private LldpPortIdSubType(Integer chassisIdsubtype) {
            this.m_type = chassisIdsubtype;
        }

        public static String getTypeString(Integer code) {
            if (s_typeMap.containsKey(code)) {
                return s_typeMap.get(code);
            }
            return null;
        }

        public static LldpPortIdSubType get(Integer code) {
            if (code == null) {
                throw new IllegalArgumentException("Cannot create LldpPortIdSubType from null code");
            }
            switch (code) {
                case 1: {
                    return LLDP_PORTID_SUBTYPE_INTERFACEALIAS;
                }
                case 2: {
                    return LLDP_PORTID_SUBTYPE_PORTCOMPONENT;
                }
                case 3: {
                    return LLDP_PORTID_SUBTYPE_MACADDRESS;
                }
                case 4: {
                    return LLDP_PORTID_SUBTYPE_NETWORKADDRESS;
                }
                case 5: {
                    return LLDP_PORTID_SUBTYPE_INTERFACENAME;
                }
                case 6: {
                    return LLDP_PORTID_SUBTYPE_AGENTCIRCUITID;
                }
                case 7: {
                    return LLDP_PORTID_SUBTYPE_LOCAL;
                }
            }
            throw new IllegalArgumentException("Cannot create LldpPortIdSubType from code " + code);
        }

        public Integer getValue() {
            return this.m_type;
        }

        static {
            s_typeMap = new HashMap<Integer, String>();
            s_typeMap.put(1, "interfaceAlias");
            s_typeMap.put(2, "portComponent");
            s_typeMap.put(3, "macAddress");
            s_typeMap.put(4, "networkAddress");
            s_typeMap.put(5, "interfaceName");
            s_typeMap.put(6, "agentCircuitId");
            s_typeMap.put(7, "local");
        }
    }

    public static enum LldpChassisIdSubType {
        LLDP_CHASSISID_SUBTYPE_CHASSISCOMPONENT(1),
        LLDP_CHASSISID_SUBTYPE_INTERFACEALIAS(2),
        LLDP_CHASSISID_SUBTYPE_PORTCOMPONENT(3),
        LLDP_CHASSISID_SUBTYPE_MACADDRESS(4),
        LLDP_CHASSISID_SUBTYPE_NETWORKADDRESS(5),
        LLDP_CHASSISID_SUBTYPE_INTERFACENAME(6),
        LLDP_CHASSISID_SUBTYPE_LOCAL(7);

        private int m_type;
        protected static final Map<Integer, String> s_typeMap;

        private LldpChassisIdSubType(int type) {
            this.m_type = type;
        }

        public static String getTypeString(Integer code) {
            if (s_typeMap.containsKey(code)) {
                return s_typeMap.get(code);
            }
            return null;
        }

        public Integer getValue() {
            return this.m_type;
        }

        public static LldpChassisIdSubType get(Integer code) {
            if (code == null) {
                throw new IllegalArgumentException("Cannot create LldpChassisIdSubType from null code");
            }
            switch (code) {
                case 1: {
                    return LLDP_CHASSISID_SUBTYPE_CHASSISCOMPONENT;
                }
                case 2: {
                    return LLDP_CHASSISID_SUBTYPE_INTERFACEALIAS;
                }
                case 3: {
                    return LLDP_CHASSISID_SUBTYPE_PORTCOMPONENT;
                }
                case 4: {
                    return LLDP_CHASSISID_SUBTYPE_MACADDRESS;
                }
                case 5: {
                    return LLDP_CHASSISID_SUBTYPE_NETWORKADDRESS;
                }
                case 6: {
                    return LLDP_CHASSISID_SUBTYPE_INTERFACENAME;
                }
                case 7: {
                    return LLDP_CHASSISID_SUBTYPE_LOCAL;
                }
            }
            throw new IllegalArgumentException("Cannot create LldpChassisIdSubType from code " + code);
        }

        static {
            s_typeMap = new HashMap<Integer, String>();
            s_typeMap.put(1, "chassisComponent");
            s_typeMap.put(2, "interfaceAlias");
            s_typeMap.put(3, "portComponent");
            s_typeMap.put(4, "macAddress");
            s_typeMap.put(5, "networkAddress");
            s_typeMap.put(6, "interfaceName");
            s_typeMap.put(7, "local");
        }
    }
}

