/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.internal.json;

import com.atlassian.jira.rest.client.domain.Attachment;
import com.atlassian.jira.rest.client.domain.BasicComponent;
import com.atlassian.jira.rest.client.domain.BasicIssueType;
import com.atlassian.jira.rest.client.domain.BasicPriority;
import com.atlassian.jira.rest.client.domain.BasicProject;
import com.atlassian.jira.rest.client.domain.BasicResolution;
import com.atlassian.jira.rest.client.domain.BasicStatus;
import com.atlassian.jira.rest.client.domain.BasicUser;
import com.atlassian.jira.rest.client.domain.BasicVotes;
import com.atlassian.jira.rest.client.domain.BasicWatchers;
import com.atlassian.jira.rest.client.domain.ChangelogGroup;
import com.atlassian.jira.rest.client.domain.Comment;
import com.atlassian.jira.rest.client.domain.Field;
import com.atlassian.jira.rest.client.domain.Issue;
import com.atlassian.jira.rest.client.domain.IssueFieldId;
import com.atlassian.jira.rest.client.domain.IssueLink;
import com.atlassian.jira.rest.client.domain.Subtask;
import com.atlassian.jira.rest.client.domain.TimeTracking;
import com.atlassian.jira.rest.client.domain.Version;
import com.atlassian.jira.rest.client.domain.Worklog;
import com.atlassian.jira.rest.client.internal.json.AttachmentJsonParser;
import com.atlassian.jira.rest.client.internal.json.BasicComponentJsonParser;
import com.atlassian.jira.rest.client.internal.json.BasicIssueTypeJsonParser;
import com.atlassian.jira.rest.client.internal.json.BasicPriorityJsonParser;
import com.atlassian.jira.rest.client.internal.json.BasicProjectJsonParser;
import com.atlassian.jira.rest.client.internal.json.BasicResolutionJsonParser;
import com.atlassian.jira.rest.client.internal.json.BasicStatusJsonParser;
import com.atlassian.jira.rest.client.internal.json.BasicUserJsonParser;
import com.atlassian.jira.rest.client.internal.json.BasicVotesJsonParser;
import com.atlassian.jira.rest.client.internal.json.ChangelogJsonParser;
import com.atlassian.jira.rest.client.internal.json.CommentJsonParser;
import com.atlassian.jira.rest.client.internal.json.IssueLinkJsonParser;
import com.atlassian.jira.rest.client.internal.json.IssueLinkJsonParserV5;
import com.atlassian.jira.rest.client.internal.json.JsonFieldParser;
import com.atlassian.jira.rest.client.internal.json.JsonObjectParser;
import com.atlassian.jira.rest.client.internal.json.JsonParseUtil;
import com.atlassian.jira.rest.client.internal.json.JsonWeakParser;
import com.atlassian.jira.rest.client.internal.json.JsonWeakParserForJsonObject;
import com.atlassian.jira.rest.client.internal.json.JsonWeakParserForString;
import com.atlassian.jira.rest.client.internal.json.SubtaskJsonParser;
import com.atlassian.jira.rest.client.internal.json.TimeTrackingJsonParser;
import com.atlassian.jira.rest.client.internal.json.TimeTrackingJsonParserV5;
import com.atlassian.jira.rest.client.internal.json.VersionJsonParser;
import com.atlassian.jira.rest.client.internal.json.WatchersJsonParserBuilder;
import com.atlassian.jira.rest.client.internal.json.WorklogJsonParser;
import com.atlassian.jira.rest.client.internal.json.WorklogJsonParserV5;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.ws.rs.core.UriBuilder;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.joda.time.DateTime;

public class IssueJsonParser
implements JsonObjectParser<Issue> {
    private static Set<String> SPECIAL_FIELDS = Sets.newHashSet(IssueFieldId.ids());
    public static final String SCHEMA_SECTION = "schema";
    public static final String NAMES_SECTION = "names";
    private final IssueLinkJsonParser issueLinkJsonParser = new IssueLinkJsonParser();
    private final IssueLinkJsonParserV5 issueLinkJsonParserV5 = new IssueLinkJsonParserV5();
    private final BasicVotesJsonParser votesJsonParser = new BasicVotesJsonParser();
    private final BasicStatusJsonParser statusJsonParser = new BasicStatusJsonParser();
    private final WorklogJsonParser worklogJsonParser = new WorklogJsonParser();
    private final JsonObjectParser<BasicWatchers> watchersJsonParser = WatchersJsonParserBuilder.createBasicWatchersParser();
    private final VersionJsonParser versionJsonParser = new VersionJsonParser();
    private final BasicComponentJsonParser basicComponentJsonParser = new BasicComponentJsonParser();
    private final AttachmentJsonParser attachmentJsonParser = new AttachmentJsonParser();
    private final JsonFieldParser fieldParser = new JsonFieldParser();
    private final CommentJsonParser commentJsonParser = new CommentJsonParser();
    private final BasicIssueTypeJsonParser issueTypeJsonParser = new BasicIssueTypeJsonParser();
    private final BasicProjectJsonParser projectJsonParser = new BasicProjectJsonParser();
    private final BasicPriorityJsonParser priorityJsonParser = new BasicPriorityJsonParser();
    private final BasicResolutionJsonParser resolutionJsonParser = new BasicResolutionJsonParser();
    private final BasicUserJsonParser userJsonParser = new BasicUserJsonParser();
    private final SubtaskJsonParser subtaskJsonParser = new SubtaskJsonParser();
    private final ChangelogJsonParser changelogJsonParser = new ChangelogJsonParser();
    private final JsonWeakParserForString jsonWeakParserForString = new JsonWeakParserForString();
    private static final String FIELDS = "fields";
    private static final String VALUE_ATTR = "value";

    static Iterable<String> parseExpandos(JSONObject json) throws JSONException {
        String expando = json.getString("expand");
        return Splitter.on(',').split(expando);
    }

    private <T> Collection<T> parseArray(JSONObject jsonObject, JsonWeakParser<T> jsonParser, String arrayAttribute) throws JSONException {
        JSONArray valueObject = jsonObject.optJSONArray(arrayAttribute);
        if (valueObject == null) {
            return new ArrayList();
        }
        ArrayList<T> res = new ArrayList<T>(valueObject.length());
        for (int i = 0; i < valueObject.length(); ++i) {
            res.add(jsonParser.parse(valueObject.get(i)));
        }
        return res;
    }

    private <T> Collection<T> parseOptionalArrayNotNullable(boolean shouldUseNestedValueJson, JSONObject json, JsonWeakParser<T> jsonParser, String ... path) throws JSONException {
        Collection<T> res = this.parseOptionalArray(shouldUseNestedValueJson, json, jsonParser, path);
        return res == null ? Collections.emptyList() : res;
    }

    @Nullable
    private <T> Collection<T> parseOptionalArray(boolean shouldUseNestedValueJson, JSONObject json, JsonWeakParser<T> jsonParser, String ... path) throws JSONException {
        if (shouldUseNestedValueJson) {
            JSONObject js = JsonParseUtil.getNestedOptionalObject(json, path);
            if (js == null) {
                return null;
            }
            return this.parseArray(js, jsonParser, VALUE_ATTR);
        }
        JSONArray jsonArray = JsonParseUtil.getNestedOptionalArray(json, path);
        if (jsonArray == null) {
            return null;
        }
        ArrayList<T> res = new ArrayList<T>(jsonArray.length());
        for (int i = 0; i < jsonArray.length(); ++i) {
            res.add(jsonParser.parse(jsonArray.get(i)));
        }
        return res;
    }

    private String getFieldStringValue(JSONObject json, String attributeName) throws JSONException {
        JSONObject fieldsJson = json.getJSONObject(FIELDS);
        Object summaryObject = fieldsJson.get(attributeName);
        if (summaryObject instanceof JSONObject) {
            return ((JSONObject)summaryObject).getString(VALUE_ATTR);
        }
        if (summaryObject instanceof String) {
            return (String)summaryObject;
        }
        throw new JSONException("Cannot parse [" + attributeName + "] from available fields");
    }

    private JSONObject getFieldUnisex(JSONObject json, String attributeName) throws JSONException {
        JSONObject fieldsJson = json.getJSONObject(FIELDS);
        JSONObject fieldJson = fieldsJson.getJSONObject(attributeName);
        if (fieldJson.has(VALUE_ATTR)) {
            return fieldJson.getJSONObject(VALUE_ATTR);
        }
        return fieldJson;
    }

    @Nullable
    private String getOptionalFieldStringUnisex(boolean shouldUseNestedValueJson, JSONObject json, String attributeName) throws JSONException {
        JSONObject fieldsJson = json.getJSONObject(FIELDS);
        if (shouldUseNestedValueJson) {
            JSONObject fieldJson = fieldsJson.optJSONObject(attributeName);
            if (fieldJson != null) {
                return JsonParseUtil.getOptionalString(fieldJson, VALUE_ATTR);
            }
            return null;
        }
        return JsonParseUtil.getOptionalString(fieldsJson, attributeName);
    }

    private String getFieldStringUnisex(JSONObject json, String attributeName) throws JSONException {
        JSONObject fieldsJson = json.getJSONObject(FIELDS);
        Object fieldJson = fieldsJson.get(attributeName);
        if (fieldJson instanceof JSONObject) {
            return ((JSONObject)fieldJson).getString(VALUE_ATTR);
        }
        return fieldJson.toString();
    }

    @Override
    public Issue parse(JSONObject s) throws JSONException {
        Object transitionsObj;
        Collection<Comment> comments;
        boolean shouldUseNestedValueAttribute;
        Iterable<String> expandos = IssueJsonParser.parseExpandos(s);
        boolean isJira5x0OrNewer = Iterables.contains(expandos, SCHEMA_SECTION);
        boolean bl = shouldUseNestedValueAttribute = !isJira5x0OrNewer;
        if (isJira5x0OrNewer) {
            JSONObject commentsJson = s.getJSONObject(FIELDS).getJSONObject(IssueFieldId.COMMENT_FIELD.id);
            comments = this.parseArray(commentsJson, new JsonWeakParserForJsonObject<Comment>(this.commentJsonParser), "comments");
        } else {
            Collection<Comment> commentsTmp = this.parseOptionalArray(shouldUseNestedValueAttribute, s, new JsonWeakParserForJsonObject<Comment>(this.commentJsonParser), FIELDS, IssueFieldId.COMMENT_FIELD.id);
            comments = commentsTmp != null ? commentsTmp : Lists.newArrayList();
        }
        String summary = this.getFieldStringValue(s, IssueFieldId.SUMMARY_FIELD.id);
        String description = this.getOptionalFieldStringUnisex(shouldUseNestedValueAttribute, s, IssueFieldId.DESCRIPTION_FIELD.id);
        Collection<Attachment> attachments = this.parseOptionalArray(shouldUseNestedValueAttribute, s, new JsonWeakParserForJsonObject<Attachment>(this.attachmentJsonParser), FIELDS, IssueFieldId.ATTACHMENT_FIELD.id);
        Collection<Field> fields = isJira5x0OrNewer ? this.parseFieldsJira5x0(s) : this.parseFields(s.getJSONObject(FIELDS));
        BasicIssueType issueType = this.issueTypeJsonParser.parse(this.getFieldUnisex(s, IssueFieldId.ISSUE_TYPE_FIELD.id));
        DateTime creationDate = JsonParseUtil.parseDateTime(this.getFieldStringUnisex(s, IssueFieldId.CREATED_FIELD.id));
        DateTime updateDate = JsonParseUtil.parseDateTime(this.getFieldStringUnisex(s, IssueFieldId.UPDATED_FIELD.id));
        String dueDateString = this.getOptionalFieldStringUnisex(shouldUseNestedValueAttribute, s, IssueFieldId.DUE_DATE_FIELD.id);
        DateTime dueDate = dueDateString == null ? null : JsonParseUtil.parseDateTimeOrDate(dueDateString);
        BasicPriority priority = this.getOptionalField(shouldUseNestedValueAttribute, s, IssueFieldId.PRIORITY_FIELD.id, this.priorityJsonParser);
        BasicResolution resolution = this.getOptionalField(shouldUseNestedValueAttribute, s, IssueFieldId.RESOLUTION_FIELD.id, this.resolutionJsonParser);
        BasicUser assignee = this.getOptionalField(shouldUseNestedValueAttribute, s, IssueFieldId.ASSIGNEE_FIELD.id, this.userJsonParser);
        BasicUser reporter = this.getOptionalField(shouldUseNestedValueAttribute, s, IssueFieldId.REPORTER_FIELD.id, this.userJsonParser);
        BasicProject project = this.projectJsonParser.parse(this.getFieldUnisex(s, IssueFieldId.PROJECT_FIELD.id));
        Collection<IssueLink> issueLinks = isJira5x0OrNewer ? this.parseOptionalArray(shouldUseNestedValueAttribute, s, new JsonWeakParserForJsonObject<IssueLink>(this.issueLinkJsonParserV5), FIELDS, IssueFieldId.LINKS_FIELD.id) : this.parseOptionalArray(shouldUseNestedValueAttribute, s, new JsonWeakParserForJsonObject<IssueLink>(this.issueLinkJsonParser), FIELDS, IssueFieldId.LINKS_PRE_5_0_FIELD.id);
        Collection<Subtask> subtasks = null;
        if (isJira5x0OrNewer) {
            subtasks = this.parseOptionalArray(shouldUseNestedValueAttribute, s, new JsonWeakParserForJsonObject<Subtask>(this.subtaskJsonParser), FIELDS, IssueFieldId.SUBTASKS_FIELD.id);
        }
        BasicVotes votes = this.getOptionalField(shouldUseNestedValueAttribute, s, IssueFieldId.VOTES_FIELD.id, this.votesJsonParser);
        BasicStatus status = this.statusJsonParser.parse(this.getFieldUnisex(s, IssueFieldId.STATUS_FIELD.id));
        Collection<Version> fixVersions = this.parseOptionalArray(shouldUseNestedValueAttribute, s, new JsonWeakParserForJsonObject<Version>(this.versionJsonParser), FIELDS, IssueFieldId.FIX_VERSIONS_FIELD.id);
        Collection<Version> affectedVersions = this.parseOptionalArray(shouldUseNestedValueAttribute, s, new JsonWeakParserForJsonObject<Version>(this.versionJsonParser), FIELDS, IssueFieldId.AFFECTS_VERSIONS_FIELD.id);
        Collection<BasicComponent> components = this.parseOptionalArray(shouldUseNestedValueAttribute, s, new JsonWeakParserForJsonObject<BasicComponent>(this.basicComponentJsonParser), FIELDS, IssueFieldId.COMPONENTS_FIELD.id);
        URI selfUri = JsonParseUtil.getSelfUri(s);
        String transitionsUriString = s.has(IssueFieldId.TRANSITIONS_FIELD.id) ? ((transitionsObj = s.get(IssueFieldId.TRANSITIONS_FIELD.id)) instanceof String ? (String)transitionsObj : null) : this.getOptionalFieldStringUnisex(shouldUseNestedValueAttribute, s, IssueFieldId.TRANSITIONS_FIELD.id);
        URI transitionsUri = this.parseTransisionsUri(transitionsUriString, selfUri);
        Collection<Object> worklogs = isJira5x0OrNewer ? (JsonParseUtil.getNestedOptionalObject(s, FIELDS, IssueFieldId.WORKLOG_FIELD.id) != null ? this.parseOptionalArray(shouldUseNestedValueAttribute, s, new JsonWeakParserForJsonObject<Worklog>(new WorklogJsonParserV5(selfUri)), FIELDS, IssueFieldId.WORKLOG_FIELD.id, IssueFieldId.WORKLOGS_FIELD.id) : Collections.emptyList()) : this.parseOptionalArray(shouldUseNestedValueAttribute, s, new JsonWeakParserForJsonObject<Worklog>(this.worklogJsonParser), FIELDS, IssueFieldId.WORKLOG_FIELD.id);
        BasicWatchers watchers = this.getOptionalField(shouldUseNestedValueAttribute, s, isJira5x0OrNewer ? IssueFieldId.WATCHER_FIELD.id : IssueFieldId.WATCHER_PRE_5_0_FIELD.id, this.watchersJsonParser);
        TimeTracking timeTracking = this.getOptionalField(shouldUseNestedValueAttribute, s, IssueFieldId.TIMETRACKING_FIELD.id, isJira5x0OrNewer ? new TimeTrackingJsonParserV5() : new TimeTrackingJsonParser());
        HashSet<String> labels = Sets.newHashSet(this.parseOptionalArrayNotNullable(shouldUseNestedValueAttribute, s, this.jsonWeakParserForString, FIELDS, IssueFieldId.LABELS_FIELD.id));
        Collection<ChangelogGroup> changelog = this.parseOptionalArray(false, s, new JsonWeakParserForJsonObject<ChangelogGroup>(this.changelogJsonParser), "changelog", "histories");
        return new Issue(summary, selfUri, s.getString("key"), project, issueType, status, description, priority, resolution, attachments, reporter, assignee, creationDate, updateDate, dueDate, affectedVersions, fixVersions, components, timeTracking, fields, comments, transitionsUri, issueLinks, votes, worklogs, watchers, expandos, subtasks, changelog, labels);
    }

    private URI parseTransisionsUri(String transitionsUriString, URI selfUri) {
        return transitionsUriString != null ? JsonParseUtil.parseURI(transitionsUriString) : UriBuilder.fromUri(selfUri).path("transitions").queryParam("expand", "transitions.fields").build(new Object[0]);
    }

    @Nullable
    private <T> T getOptionalField(boolean shouldUseNestedValue, JSONObject s, String fieldId, JsonObjectParser<T> jsonParser) throws JSONException {
        JSONObject fieldJson = JsonParseUtil.getNestedOptionalObject(s, FIELDS, fieldId);
        if (fieldJson != null) {
            if (shouldUseNestedValue) {
                JSONObject valueJsonObject = fieldJson.optJSONObject(VALUE_ATTR);
                if (valueJsonObject != null) {
                    return jsonParser.parse(valueJsonObject);
                }
            } else {
                return jsonParser.parse(fieldJson);
            }
        }
        return null;
    }

    private Collection<Field> parseFieldsJira5x0(JSONObject issueJson) throws JSONException {
        JSONObject names = issueJson.optJSONObject(NAMES_SECTION);
        Map<String, String> namesMap = this.parseNames(names);
        JSONObject types = issueJson.optJSONObject(SCHEMA_SECTION);
        Map<String, String> typesMap = this.parseSchema(types);
        JSONObject json = issueJson.getJSONObject(FIELDS);
        ArrayList<Field> res = new ArrayList<Field>(json.length());
        Iterator iterator = json.keys();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            try {
                Object value;
                if (SPECIAL_FIELDS.contains(key)) continue;
                res.add(new Field(key, namesMap.get(key), typesMap.get("key"), (value = json.opt(key)) != JSONObject.NULL ? value : null));
            }
            catch (Exception e) {
                throw new JSONException("Error while parsing [" + key + "] field: " + e.getMessage()){

                    @Override
                    public Throwable getCause() {
                        return e;
                    }
                };
            }
        }
        return res;
    }

    private Map<String, String> parseSchema(JSONObject json) throws JSONException {
        HashMap<String, String> res = Maps.newHashMap();
        Iterator<String> it = JsonParseUtil.getStringKeys(json);
        while (it.hasNext()) {
            String fieldId = it.next();
            JSONObject fieldDefinition = json.getJSONObject(fieldId);
            res.put(fieldId, fieldDefinition.getString("type"));
        }
        return res;
    }

    private Map<String, String> parseNames(JSONObject json) throws JSONException {
        HashMap<String, String> res = Maps.newHashMap();
        Iterator<String> iterator = JsonParseUtil.getStringKeys(json);
        while (iterator.hasNext()) {
            String key = iterator.next();
            res.put(key, json.getString(key));
        }
        return res;
    }

    private Collection<Field> parseFields(JSONObject json) throws JSONException {
        ArrayList<Field> res = new ArrayList<Field>(json.length());
        Iterator<String> iterator = JsonParseUtil.getStringKeys(json);
        while (iterator.hasNext()) {
            String key = iterator.next();
            if (SPECIAL_FIELDS.contains(key)) continue;
            res.add(this.fieldParser.parse(json.getJSONObject(key), key));
        }
        return res;
    }
}

