/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.internal.jersey;

import com.atlassian.jira.rest.client.AuthenticationHandler;
import com.atlassian.jira.rest.client.ComponentRestClient;
import com.atlassian.jira.rest.client.IssueRestClient;
import com.atlassian.jira.rest.client.JiraRestClient;
import com.atlassian.jira.rest.client.MetadataRestClient;
import com.atlassian.jira.rest.client.ProjectRestClient;
import com.atlassian.jira.rest.client.ProjectRolesRestClient;
import com.atlassian.jira.rest.client.SearchRestClient;
import com.atlassian.jira.rest.client.SessionRestClient;
import com.atlassian.jira.rest.client.UserRestClient;
import com.atlassian.jira.rest.client.VersionRestClient;
import com.atlassian.jira.rest.client.internal.jersey.JerseyComponentRestClient;
import com.atlassian.jira.rest.client.internal.jersey.JerseyIssueRestClient;
import com.atlassian.jira.rest.client.internal.jersey.JerseyMetadataRestClient;
import com.atlassian.jira.rest.client.internal.jersey.JerseyProjectRestClient;
import com.atlassian.jira.rest.client.internal.jersey.JerseyProjectRolesRestClient;
import com.atlassian.jira.rest.client.internal.jersey.JerseySearchRestClient;
import com.atlassian.jira.rest.client.internal.jersey.JerseySessionRestClient;
import com.atlassian.jira.rest.client.internal.jersey.JerseyUserRestClient;
import com.atlassian.jira.rest.client.internal.jersey.JerseyVersionRestClient;
import com.sun.jersey.api.client.AsyncViewResource;
import com.sun.jersey.api.client.AsyncWebResource;
import com.sun.jersey.api.client.ViewResource;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.client.apache.ApacheHttpClient;
import com.sun.jersey.client.apache.ApacheHttpClientHandler;
import com.sun.jersey.client.apache.config.DefaultApacheHttpClientConfig;
import java.net.URI;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;

public class JerseyJiraRestClient
implements JiraRestClient {
    private final URI baseUri;
    private final IssueRestClient issueRestClient;
    private final SessionRestClient sessionRestClient;
    private final UserRestClient userRestClient;
    private final ProjectRestClient projectRestClient;
    private final ComponentRestClient componentRestClient;
    private final MetadataRestClient metadataRestClient;
    private final SearchRestClient searchRestClient;
    private final VersionRestClient versionRestClient;
    private final ProjectRolesRestClient projectRolesRestClient;

    public JerseyJiraRestClient(URI serverUri, final AuthenticationHandler authenticationHandler) {
        this.baseUri = UriBuilder.fromUri(serverUri).path("/rest/api/latest").build(new Object[0]);
        DefaultApacheHttpClientConfig config = new DefaultApacheHttpClientConfig();
        authenticationHandler.configure(config);
        ApacheHttpClient client = new ApacheHttpClient(JerseyJiraRestClient.createDefaultClientHander(config)){

            @Override
            public WebResource resource(URI u) {
                WebResource resource = super.resource(u);
                authenticationHandler.configure(resource, this);
                return resource;
            }

            @Override
            public AsyncWebResource asyncResource(URI u) {
                AsyncWebResource resource = super.asyncResource(u);
                authenticationHandler.configure(resource, this);
                return resource;
            }

            @Override
            public ViewResource viewResource(URI u) {
                ViewResource resource = super.viewResource(u);
                authenticationHandler.configure(resource, this);
                return resource;
            }

            @Override
            public AsyncViewResource asyncViewResource(URI u) {
                AsyncViewResource resource = super.asyncViewResource(u);
                authenticationHandler.configure(resource, this);
                return resource;
            }
        };
        this.metadataRestClient = new JerseyMetadataRestClient(this.baseUri, client);
        this.sessionRestClient = new JerseySessionRestClient(client, serverUri);
        this.issueRestClient = new JerseyIssueRestClient(this.baseUri, client, this.sessionRestClient, this.metadataRestClient);
        this.userRestClient = new JerseyUserRestClient(this.baseUri, client);
        this.projectRestClient = new JerseyProjectRestClient(this.baseUri, client);
        this.componentRestClient = new JerseyComponentRestClient(this.baseUri, client);
        this.searchRestClient = new JerseySearchRestClient(this.baseUri, client);
        this.versionRestClient = new JerseyVersionRestClient(this.baseUri, client);
        this.projectRolesRestClient = new JerseyProjectRolesRestClient(this.baseUri, client, serverUri);
    }

    @Override
    public IssueRestClient getIssueClient() {
        return this.issueRestClient;
    }

    @Override
    public SessionRestClient getSessionClient() {
        return this.sessionRestClient;
    }

    @Override
    public UserRestClient getUserClient() {
        return this.userRestClient;
    }

    @Override
    public ProjectRestClient getProjectClient() {
        return this.projectRestClient;
    }

    @Override
    public ComponentRestClient getComponentClient() {
        return this.componentRestClient;
    }

    @Override
    public MetadataRestClient getMetadataClient() {
        return this.metadataRestClient;
    }

    @Override
    public SearchRestClient getSearchClient() {
        return this.searchRestClient;
    }

    @Override
    public VersionRestClient getVersionRestClient() {
        return this.versionRestClient;
    }

    @Override
    public ProjectRolesRestClient getProjectRolesRestClient() {
        return this.projectRolesRestClient;
    }

    private static ApacheHttpClientHandler createDefaultClientHander(DefaultApacheHttpClientConfig config) {
        HttpClient client = new HttpClient(new MultiThreadedHttpConnectionManager());
        return new ApacheHttpClientHandler(client, config);
    }
}

