/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.internal.jersey;

import com.atlassian.jira.rest.client.GetCreateIssueMetadataOptions;
import com.atlassian.jira.rest.client.IssueRestClient;
import com.atlassian.jira.rest.client.MetadataRestClient;
import com.atlassian.jira.rest.client.ProgressMonitor;
import com.atlassian.jira.rest.client.RestClientException;
import com.atlassian.jira.rest.client.SessionRestClient;
import com.atlassian.jira.rest.client.domain.BasicIssue;
import com.atlassian.jira.rest.client.domain.CimProject;
import com.atlassian.jira.rest.client.domain.Comment;
import com.atlassian.jira.rest.client.domain.Issue;
import com.atlassian.jira.rest.client.domain.ServerInfo;
import com.atlassian.jira.rest.client.domain.Session;
import com.atlassian.jira.rest.client.domain.Transition;
import com.atlassian.jira.rest.client.domain.Votes;
import com.atlassian.jira.rest.client.domain.Watchers;
import com.atlassian.jira.rest.client.domain.input.AttachmentInput;
import com.atlassian.jira.rest.client.domain.input.FieldInput;
import com.atlassian.jira.rest.client.domain.input.IssueInput;
import com.atlassian.jira.rest.client.domain.input.LinkIssuesInput;
import com.atlassian.jira.rest.client.domain.input.TransitionInput;
import com.atlassian.jira.rest.client.domain.input.WorklogInput;
import com.atlassian.jira.rest.client.internal.jersey.AbstractJerseyRestClient;
import com.atlassian.jira.rest.client.internal.json.BasicIssueJsonParser;
import com.atlassian.jira.rest.client.internal.json.CreateIssueMetadataJsonParser;
import com.atlassian.jira.rest.client.internal.json.IssueJsonParser;
import com.atlassian.jira.rest.client.internal.json.JsonObjectParser;
import com.atlassian.jira.rest.client.internal.json.JsonParseUtil;
import com.atlassian.jira.rest.client.internal.json.TransitionJsonParser;
import com.atlassian.jira.rest.client.internal.json.TransitionJsonParserV5;
import com.atlassian.jira.rest.client.internal.json.VotesJsonParser;
import com.atlassian.jira.rest.client.internal.json.WatchersJsonParserBuilder;
import com.atlassian.jira.rest.client.internal.json.gen.CommentJsonGenerator;
import com.atlassian.jira.rest.client.internal.json.gen.ComplexIssueInputFieldValueJsonGenerator;
import com.atlassian.jira.rest.client.internal.json.gen.IssueInputJsonGenerator;
import com.atlassian.jira.rest.client.internal.json.gen.LinkIssuesInputGenerator;
import com.atlassian.jira.rest.client.internal.json.gen.WorklogInputJsonGenerator;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.client.apache.ApacheHttpClient;
import com.sun.jersey.core.header.FormDataContentDisposition;
import com.sun.jersey.multipart.BodyPart;
import com.sun.jersey.multipart.MultiPart;
import com.sun.jersey.multipart.MultiPartMediaTypes;
import com.sun.jersey.multipart.file.FileDataBodyPart;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.UriBuilder;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class JerseyIssueRestClient
extends AbstractJerseyRestClient
implements IssueRestClient {
    private static final String FILE_ATTACHMENT_CONTROL_NAME = "file";
    private static final EnumSet<IssueRestClient.Expandos> DEFAULT_EXPANDS = EnumSet.of(IssueRestClient.Expandos.NAMES, IssueRestClient.Expandos.SCHEMA, IssueRestClient.Expandos.TRANSITIONS);
    private static final Function<IssueRestClient.Expandos, String> EXPANDO_TO_PARAM = new Function<IssueRestClient.Expandos, String>(){

        @Override
        public String apply(IssueRestClient.Expandos from) {
            return from.name().toLowerCase();
        }
    };
    private final SessionRestClient sessionRestClient;
    private final MetadataRestClient metadataRestClient;
    private final IssueJsonParser issueParser = new IssueJsonParser();
    private final BasicIssueJsonParser basicIssueParser = new BasicIssueJsonParser();
    private final JsonObjectParser<Watchers> watchersParser = WatchersJsonParserBuilder.createWatchersParser();
    private final TransitionJsonParser transitionJsonParser = new TransitionJsonParser();
    private final JsonObjectParser<Transition> transitionJsonParserV5 = new TransitionJsonParserV5();
    private final VotesJsonParser votesJsonParser = new VotesJsonParser();
    private final CreateIssueMetadataJsonParser createIssueMetadataJsonParser = new CreateIssueMetadataJsonParser();
    private ServerInfo serverInfo;

    public JerseyIssueRestClient(URI baseUri, ApacheHttpClient client, SessionRestClient sessionRestClient, MetadataRestClient metadataRestClient) {
        super(baseUri, client);
        this.sessionRestClient = sessionRestClient;
        this.metadataRestClient = metadataRestClient;
    }

    private synchronized ServerInfo getVersionInfo(ProgressMonitor progressMonitor) {
        if (this.serverInfo == null) {
            this.serverInfo = this.metadataRestClient.getServerInfo(progressMonitor);
        }
        return this.serverInfo;
    }

    @Override
    public Watchers getWatchers(URI watchersUri, ProgressMonitor progressMonitor) {
        return this.getAndParse(watchersUri, this.watchersParser, progressMonitor);
    }

    @Override
    public Votes getVotes(URI votesUri, ProgressMonitor progressMonitor) {
        return this.getAndParse(votesUri, this.votesJsonParser, progressMonitor);
    }

    @Override
    public Issue getIssue(String issueKey, ProgressMonitor progressMonitor) {
        return this.getIssue(issueKey, Collections.<IssueRestClient.Expandos>emptyList(), progressMonitor);
    }

    @Override
    public Issue getIssue(String issueKey, Iterable<IssueRestClient.Expandos> expand, ProgressMonitor progressMonitor) {
        UriBuilder uriBuilder = UriBuilder.fromUri(this.baseUri);
        Iterable<IssueRestClient.Expandos> expands = Iterables.concat(DEFAULT_EXPANDS, expand);
        uriBuilder.path("issue").path(issueKey).queryParam("expand", Joiner.on(',').join(Iterables.transform(expands, EXPANDO_TO_PARAM)));
        return this.getAndParse(uriBuilder.build(new Object[0]), this.issueParser, progressMonitor);
    }

    @Override
    public Iterable<Transition> getTransitions(final URI transitionsUri, ProgressMonitor progressMonitor) {
        return this.invoke(new Callable<Iterable<Transition>>(){

            @Override
            public Iterable<Transition> call() throws Exception {
                WebResource transitionsResource = JerseyIssueRestClient.this.client.resource(transitionsUri);
                JSONObject jsonObject = transitionsResource.get(JSONObject.class);
                if (jsonObject.has("transitions")) {
                    return JsonParseUtil.parseJsonArray(jsonObject.getJSONArray("transitions"), JerseyIssueRestClient.this.transitionJsonParserV5);
                }
                ArrayList<Transition> transitions = new ArrayList<Transition>(jsonObject.length());
                Iterator iterator = jsonObject.keys();
                while (iterator.hasNext()) {
                    String key = (String)iterator.next();
                    try {
                        int id = Integer.parseInt(key);
                        Transition transition = JerseyIssueRestClient.this.transitionJsonParser.parse(jsonObject.getJSONObject(key), id);
                        transitions.add(transition);
                    }
                    catch (JSONException e) {
                        throw new RestClientException(e);
                    }
                    catch (NumberFormatException e) {
                        throw new RestClientException("Transition id should be an integer, but found [" + key + "]", (Throwable)e);
                    }
                }
                return transitions;
            }
        });
    }

    @Override
    public Iterable<Transition> getTransitions(Issue issue, ProgressMonitor progressMonitor) {
        return this.getTransitions(issue.getTransitionsUri(), progressMonitor);
    }

    @Override
    public void transition(final URI transitionsUri, final TransitionInput transitionInput, final ProgressMonitor progressMonitor) {
        final int buildNumber = this.getVersionInfo(progressMonitor).getBuildNumber();
        this.invoke(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                JSONObject jsonObject = new JSONObject();
                if (buildNumber >= 700) {
                    jsonObject.put("transition", new JSONObject().put("id", transitionInput.getId()));
                } else {
                    jsonObject.put("transition", transitionInput.getId());
                }
                if (transitionInput.getComment() != null) {
                    if (buildNumber >= 700) {
                        jsonObject.put("update", new JSONObject().put("comment", new JSONArray().put(new JSONObject().put("add", new CommentJsonGenerator(JerseyIssueRestClient.this.getVersionInfo(progressMonitor)).generate(transitionInput.getComment())))));
                    } else {
                        jsonObject.put("comment", new CommentJsonGenerator(JerseyIssueRestClient.this.getVersionInfo(progressMonitor)).generate(transitionInput.getComment()));
                    }
                }
                JSONObject fieldsJs = new JSONObject();
                Iterable<FieldInput> fields = transitionInput.getFields();
                ComplexIssueInputFieldValueJsonGenerator fieldValueGenerator = new ComplexIssueInputFieldValueJsonGenerator();
                if (fields.iterator().hasNext()) {
                    for (FieldInput fieldInput : fields) {
                        fieldsJs.put(fieldInput.getId(), fieldValueGenerator.generateFieldValueForJson(fieldInput.getValue()));
                    }
                }
                if (fieldsJs.keys().hasNext()) {
                    jsonObject.put("fields", fieldsJs);
                }
                WebResource issueResource = JerseyIssueRestClient.this.client.resource(transitionsUri);
                issueResource.post(jsonObject);
                return null;
            }
        });
    }

    @Override
    public void transition(Issue issue, TransitionInput transitionInput, ProgressMonitor progressMonitor) {
        this.transition(issue.getTransitionsUri(), transitionInput, progressMonitor);
    }

    @Override
    public void vote(final URI votesUri, ProgressMonitor progressMonitor) {
        this.invoke(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                WebResource votesResource = JerseyIssueRestClient.this.client.resource(votesUri);
                votesResource.post();
                return null;
            }
        });
    }

    @Override
    public void unvote(final URI votesUri, ProgressMonitor progressMonitor) {
        this.invoke(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                WebResource votesResource = JerseyIssueRestClient.this.client.resource(votesUri);
                votesResource.delete();
                return null;
            }
        });
    }

    @Override
    public void addWatcher(final URI watchersUri, final @Nullable String username, ProgressMonitor progressMonitor) {
        this.invoke(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                WebResource.Builder builder = JerseyIssueRestClient.this.client.resource(watchersUri).type(MediaType.APPLICATION_JSON_TYPE);
                if (username != null) {
                    builder.post(JSONObject.quote(username));
                } else {
                    builder.post();
                }
                return null;
            }
        });
    }

    private String getLoggedUsername(ProgressMonitor progressMonitor) {
        Session session = this.sessionRestClient.getCurrentSession(progressMonitor);
        return session.getUsername();
    }

    @Override
    public void removeWatcher(URI watchersUri, String username, ProgressMonitor progressMonitor) {
        UriBuilder uriBuilder = UriBuilder.fromUri(watchersUri);
        if (this.getVersionInfo(progressMonitor).getBuildNumber() >= 640) {
            uriBuilder.queryParam("username", username);
        } else {
            uriBuilder.path(username).build(new Object[0]);
        }
        this.delete(uriBuilder.build(new Object[0]), progressMonitor);
    }

    @Override
    public void linkIssue(final LinkIssuesInput linkIssuesInput, final ProgressMonitor progressMonitor) {
        URI uri = UriBuilder.fromUri(this.baseUri).path("issueLink").build(new Object[0]);
        this.post(uri, new Callable<JSONObject>(){

            @Override
            public JSONObject call() throws Exception {
                return new LinkIssuesInputGenerator(JerseyIssueRestClient.this.getVersionInfo(progressMonitor)).generate(linkIssuesInput);
            }
        }, progressMonitor);
    }

    @Override
    public void addAttachment(ProgressMonitor progressMonitor, URI attachmentsUri, InputStream in, String filename) {
        this.addAttachments(progressMonitor, attachmentsUri, new AttachmentInput(filename, in));
    }

    @Override
    public void addAttachments(ProgressMonitor progressMonitor, final URI attachmentsUri, AttachmentInput ... attachments) {
        final ArrayList<AttachmentInput> myAttachments = Lists.newArrayList(attachments);
        this.invoke(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                MultiPart multiPartInput = new MultiPart();
                for (AttachmentInput attachment : myAttachments) {
                    BodyPart bp = new BodyPart(attachment.getInputStream(), MediaType.APPLICATION_OCTET_STREAM_TYPE);
                    FormDataContentDisposition.FormDataContentDispositionBuilder dispositionBuilder = FormDataContentDisposition.name(JerseyIssueRestClient.FILE_ATTACHMENT_CONTROL_NAME);
                    dispositionBuilder.fileName(attachment.getFilename());
                    FormDataContentDisposition formDataContentDisposition = dispositionBuilder.build();
                    bp.setContentDisposition(formDataContentDisposition);
                    multiPartInput.bodyPart(bp);
                }
                JerseyIssueRestClient.this.postFileMultiPart(multiPartInput, attachmentsUri);
                return null;
            }
        });
    }

    @Override
    public InputStream getAttachment(ProgressMonitor pm, final URI attachmentUri) {
        return this.invoke(new Callable<InputStream>(){

            @Override
            public InputStream call() throws Exception {
                WebResource attachmentResource = JerseyIssueRestClient.this.client.resource(attachmentUri);
                return attachmentResource.get(InputStream.class);
            }
        });
    }

    @Override
    public void addAttachments(ProgressMonitor progressMonitor, final URI attachmentsUri, File ... files) {
        final ArrayList<File> myFiles = Lists.newArrayList(files);
        this.invoke(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                MultiPart multiPartInput = new MultiPart();
                for (File file : myFiles) {
                    FileDataBodyPart fileDataBodyPart = new FileDataBodyPart(JerseyIssueRestClient.FILE_ATTACHMENT_CONTROL_NAME, file);
                    multiPartInput.bodyPart(fileDataBodyPart);
                }
                JerseyIssueRestClient.this.postFileMultiPart(multiPartInput, attachmentsUri);
                return null;
            }
        });
    }

    @Override
    public void addComment(final ProgressMonitor progressMonitor, URI commentsUri, final Comment comment) {
        this.post(commentsUri, new Callable<JSONObject>(){

            @Override
            public JSONObject call() throws Exception {
                return new CommentJsonGenerator(JerseyIssueRestClient.this.getVersionInfo(progressMonitor)).generate(comment);
            }
        }, progressMonitor);
    }

    private void postFileMultiPart(MultiPart multiPartInput, URI attachmentsUri) {
        WebResource attachmentsResource = this.client.resource(attachmentsUri);
        WebResource.Builder builder = attachmentsResource.type(MultiPartMediaTypes.createFormData());
        builder.header("X-Atlassian-Token", "nocheck");
        builder.post(multiPartInput);
    }

    @Override
    public void watch(URI watchersUri, ProgressMonitor progressMonitor) {
        this.addWatcher(watchersUri, null, progressMonitor);
    }

    @Override
    public void unwatch(URI watchersUri, ProgressMonitor progressMonitor) {
        this.removeWatcher(watchersUri, this.getLoggedUsername(progressMonitor), progressMonitor);
    }

    @Override
    public BasicIssue createIssue(IssueInput issue, ProgressMonitor progressMonitor) {
        UriBuilder uriBuilder = UriBuilder.fromUri(this.baseUri);
        uriBuilder.path("issue");
        return this.postAndParse(uriBuilder.build(new Object[0]), AbstractJerseyRestClient.InputGeneratorCallable.create(new IssueInputJsonGenerator(), issue), this.basicIssueParser, progressMonitor);
    }

    @Override
    public Iterable<CimProject> getCreateIssueMetadata(@Nullable GetCreateIssueMetadataOptions options, ProgressMonitor progressMonitor) {
        UriBuilder uriBuilder = UriBuilder.fromUri(this.baseUri).path("issue/createmeta");
        if (options != null) {
            Iterable<String> expandos;
            Iterable<String> issueTypeNames;
            if (options.projectIds != null) {
                uriBuilder.queryParam("projectIds", Joiner.on(",").join(options.projectIds));
            }
            if (options.projectKeys != null) {
                uriBuilder.queryParam("projectKeys", Joiner.on(",").join(options.projectKeys));
            }
            if (options.issueTypeIds != null) {
                uriBuilder.queryParam("issuetypeIds", Joiner.on(",").join(options.issueTypeIds));
            }
            if ((issueTypeNames = options.issueTypeNames) != null) {
                for (String name : issueTypeNames) {
                    uriBuilder.queryParam("issuetypeNames", name);
                }
            }
            if ((expandos = options.expandos) != null && expandos.iterator().hasNext()) {
                uriBuilder.queryParam("expand", Joiner.on(",").join(expandos));
            }
        }
        return this.getAndParse(uriBuilder.build(new Object[0]), this.createIssueMetadataJsonParser, progressMonitor);
    }

    @Override
    public void addWorklog(URI worklogUri, final WorklogInput worklogInput, ProgressMonitor progressMonitor) {
        UriBuilder uriBuilder = UriBuilder.fromUri(worklogUri).queryParam("adjustEstimate", worklogInput.getAdjustEstimate().restValue);
        switch (worklogInput.getAdjustEstimate()) {
            case NEW: {
                uriBuilder.queryParam("newEstimate", Strings.nullToEmpty(worklogInput.getAdjustEstimateValue()));
                break;
            }
            case MANUAL: {
                uriBuilder.queryParam("reduceBy", Strings.nullToEmpty(worklogInput.getAdjustEstimateValue()));
            }
        }
        this.post(uriBuilder.build(new Object[0]), new Callable<JSONObject>(){

            @Override
            public JSONObject call() throws Exception {
                return new WorklogInputJsonGenerator().generate(worklogInput);
            }
        }, progressMonitor);
    }
}

