/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.internal.jersey;

import com.atlassian.jira.rest.client.ProgressMonitor;
import com.atlassian.jira.rest.client.RestClientException;
import com.atlassian.jira.rest.client.internal.json.JsonArrayParser;
import com.atlassian.jira.rest.client.internal.json.JsonObjectParser;
import com.atlassian.jira.rest.client.internal.json.JsonParseUtil;
import com.atlassian.jira.rest.client.internal.json.gen.JsonGenerator;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.client.apache.ApacheHttpClient;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public abstract class AbstractJerseyRestClient {
    protected final ApacheHttpClient client;
    protected final URI baseUri;

    public AbstractJerseyRestClient(URI baseUri, ApacheHttpClient client) {
        this.baseUri = baseUri;
        this.client = client;
    }

    protected <T> T invoke(Callable<T> callable) throws RestClientException {
        try {
            return callable.call();
        }
        catch (UniformInterfaceException e) {
            try {
                String body = e.getResponse().getEntity(String.class);
                Collection<String> errorMessages = AbstractJerseyRestClient.extractErrors(body);
                throw new RestClientException(errorMessages, (Throwable)e);
            }
            catch (JSONException e1) {
                throw new RestClientException(e);
            }
        }
        catch (RestClientException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RestClientException(e);
        }
    }

    protected <T> T getAndParse(final URI uri, final JsonObjectParser<T> parser, ProgressMonitor progressMonitor) {
        return this.invoke(new Callable<T>(){

            @Override
            public T call() throws Exception {
                WebResource webResource = AbstractJerseyRestClient.this.client.resource(uri);
                JSONObject s = webResource.get(JSONObject.class);
                return parser.parse(s);
            }
        });
    }

    protected <T> T getAndParse(final URI uri, final JsonArrayParser<T> parser, ProgressMonitor progressMonitor) {
        return this.invoke(new Callable<T>(){

            @Override
            public T call() throws Exception {
                WebResource webResource = AbstractJerseyRestClient.this.client.resource(uri);
                JSONArray jsonArray = webResource.get(JSONArray.class);
                return parser.parse(jsonArray);
            }
        });
    }

    protected void delete(final URI uri, ProgressMonitor progressMonitor) {
        this.invoke(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                WebResource webResource = AbstractJerseyRestClient.this.client.resource(uri);
                webResource.delete();
                return null;
            }
        });
    }

    protected <T> T postAndParse(final URI uri, final @Nullable JSONObject postEntity, final JsonObjectParser<T> parser, ProgressMonitor progressMonitor) {
        return this.invoke(new Callable<T>(){

            @Override
            public T call() throws Exception {
                WebResource webResource = AbstractJerseyRestClient.this.client.resource(uri);
                JSONObject s = postEntity != null ? webResource.post(JSONObject.class, (Object)postEntity) : webResource.post(JSONObject.class);
                return parser.parse(s);
            }
        });
    }

    protected void post(URI uri, final @Nullable JSONObject postEntity, ProgressMonitor progressMonitor) {
        this.post(uri, new Callable<JSONObject>(){

            @Override
            public JSONObject call() throws Exception {
                return postEntity;
            }
        }, progressMonitor);
    }

    protected void post(final URI uri, final Callable<JSONObject> callable, ProgressMonitor progressMonitor) {
        this.invoke(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                WebResource webResource = AbstractJerseyRestClient.this.client.resource(uri);
                JSONObject postEntity = (JSONObject)callable.call();
                if (postEntity != null) {
                    webResource.post(postEntity);
                } else {
                    webResource.post();
                }
                return null;
            }
        });
    }

    protected <T> T postAndParse(URI uri, Callable<JSONObject> callable, JsonObjectParser<T> parser, ProgressMonitor progressMonitor) {
        return this.impl(uri, Method.POST, callable, parser);
    }

    protected <T> T putAndParse(URI uri, Callable<JSONObject> callable, JsonObjectParser<T> parser, ProgressMonitor progressMonitor) {
        return this.impl(uri, Method.PUT, callable, parser);
    }

    private <T> T impl(final URI uri, final Method method, final Callable<JSONObject> callable, final JsonObjectParser<T> parser) {
        return this.invoke(new Callable<T>(){

            @Override
            public T call() throws Exception {
                WebResource webResource = AbstractJerseyRestClient.this.client.resource(uri);
                JSONObject postEntity = (JSONObject)callable.call();
                JSONObject s = AbstractJerseyRestClient.this.doHttpMethod(webResource, postEntity, method);
                return parser.parse(s);
            }
        });
    }

    private JSONObject doHttpMethod(WebResource webResource, @Nullable JSONObject postEntity, Method method) {
        if (postEntity != null) {
            if (method == Method.POST) {
                return webResource.post(JSONObject.class, (Object)postEntity);
            }
            return webResource.put(JSONObject.class, (Object)postEntity);
        }
        if (method == Method.POST) {
            return webResource.post(JSONObject.class);
        }
        return webResource.put(JSONObject.class);
    }

    static Collection<String> extractErrors(String body) throws JSONException {
        JSONArray valuesJsonArray;
        JSONObject errorJsonObject;
        JSONObject jsonObject = new JSONObject(body);
        ArrayList<String> errorMessages = new ArrayList<String>();
        JSONArray errorMessagesJsonArray = jsonObject.optJSONArray("errorMessages");
        if (errorMessagesJsonArray != null) {
            errorMessages.addAll(JsonParseUtil.toStringCollection(errorMessagesJsonArray));
        }
        if ((errorJsonObject = jsonObject.optJSONObject("errors")) != null && (valuesJsonArray = errorJsonObject.toJSONArray(errorJsonObject.names())) != null) {
            errorMessages.addAll(JsonParseUtil.toStringCollection(valuesJsonArray));
        }
        return errorMessages;
    }

    protected static class InputGeneratorCallable<T>
    implements Callable<JSONObject> {
        private final JsonGenerator<T> generator;
        private final T bean;

        public static <T> InputGeneratorCallable<T> create(JsonGenerator<T> generator, T bean) {
            return new InputGeneratorCallable<T>(generator, bean);
        }

        public InputGeneratorCallable(JsonGenerator<T> generator, T bean) {
            this.generator = generator;
            this.bean = bean;
        }

        @Override
        public JSONObject call() throws Exception {
            return this.generator.generate(this.bean);
        }
    }

    static enum Method {
        PUT,
        POST;

    }
}

