/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.domain;

import com.google.common.base.Objects;
import java.net.URI;
import javax.annotation.Nullable;
import org.joda.time.DateTime;

public class ServerInfo {
    private final URI baseUri;
    private final String version;
    private final int buildNumber;
    private final DateTime buildDate;
    @Nullable
    private final DateTime serverTime;
    private final String scmInfo;
    private final String serverTitle;

    public ServerInfo(URI baseUri, String version, int buildNumber, DateTime buildDate, @Nullable DateTime serverTime, String scmInfo, String serverTitle) {
        this.baseUri = baseUri;
        this.version = version;
        this.buildNumber = buildNumber;
        this.buildDate = buildDate;
        this.serverTime = serverTime;
        this.scmInfo = scmInfo;
        this.serverTitle = serverTitle;
    }

    public URI getBaseUri() {
        return this.baseUri;
    }

    public String getVersion() {
        return this.version;
    }

    public int getBuildNumber() {
        return this.buildNumber;
    }

    public DateTime getBuildDate() {
        return this.buildDate;
    }

    @Nullable
    public DateTime getServerTime() {
        return this.serverTime;
    }

    public String getScmInfo() {
        return this.scmInfo;
    }

    public String getServerTitle() {
        return this.serverTitle;
    }

    public String toString() {
        return Objects.toStringHelper(this).addValue(super.toString()).add("baseUri", this.baseUri).add("version", this.version).add("buildNumber", this.buildNumber).add("buildDate", this.buildDate).add("serverTime", this.serverTime).add("svnRevision", this.scmInfo).add("serverTitle", this.serverTitle).toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ServerInfo) {
            ServerInfo that = (ServerInfo)obj;
            return Objects.equal(this.baseUri, that.baseUri) && Objects.equal(this.version, that.version) && Objects.equal(this.buildNumber, that.buildNumber) && Objects.equal(this.buildDate, that.buildDate) && Objects.equal(this.serverTime, that.serverTime) && Objects.equal(this.scmInfo, that.scmInfo) && Objects.equal(this.serverTitle, that.serverTitle);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.baseUri, this.version, this.buildNumber, this.buildDate, this.serverTime, this.scmInfo, this.serverTitle);
    }
}

