/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.domain;

import com.atlassian.jira.rest.client.domain.AssigneeType;
import com.atlassian.jira.rest.client.domain.BasicComponent;
import com.atlassian.jira.rest.client.domain.BasicUser;
import com.google.common.base.Objects;
import java.net.URI;
import javax.annotation.Nullable;

public class Component
extends BasicComponent {
    private final BasicUser lead;
    @Nullable
    private AssigneeInfo assigneeInfo;

    public Component(URI self, @Nullable Long id, String name, String description, BasicUser lead) {
        super(self, id, name, description);
        this.lead = lead;
    }

    public Component(URI self, @Nullable Long id, String name, String description, BasicUser lead, @Nullable AssigneeInfo assigneeInfo) {
        this(self, id, name, description, lead);
        this.assigneeInfo = assigneeInfo;
    }

    public BasicUser getLead() {
        return this.lead;
    }

    @Nullable
    public AssigneeInfo getAssigneeInfo() {
        return this.assigneeInfo;
    }

    @Override
    public String toString() {
        return Objects.toStringHelper(this).addValue(super.toString()).add("lead", this.lead).add("assigneeInfo", this.assigneeInfo).toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof Component) {
            Component that = (Component)obj;
            return super.equals(obj) && Objects.equal(this.lead, that.lead) && Objects.equal(this.assigneeInfo, that.assigneeInfo);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(super.hashCode(), this.lead, this.assigneeInfo);
    }

    public static class AssigneeInfo {
        @Nullable
        private final BasicUser assignee;
        private final AssigneeType assigneeType;
        @Nullable
        private final BasicUser realAssignee;
        private final AssigneeType realAssigneeType;
        private final boolean isAssigneeTypeValid;

        public AssigneeInfo(BasicUser assignee, AssigneeType assigneeType, @Nullable BasicUser realAssignee, AssigneeType realAssigneeType, boolean assigneeTypeValid) {
            this.assignee = assignee;
            this.assigneeType = assigneeType;
            this.realAssignee = realAssignee;
            this.realAssigneeType = realAssigneeType;
            this.isAssigneeTypeValid = assigneeTypeValid;
        }

        @Nullable
        public BasicUser getAssignee() {
            return this.assignee;
        }

        public AssigneeType getAssigneeType() {
            return this.assigneeType;
        }

        @Nullable
        public BasicUser getRealAssignee() {
            return this.realAssignee;
        }

        public AssigneeType getRealAssigneeType() {
            return this.realAssigneeType;
        }

        public boolean isAssigneeTypeValid() {
            return this.isAssigneeTypeValid;
        }

        public String toString() {
            return Objects.toStringHelper(this).add("assignee", this.assignee).add("assigneeType", (Object)this.assigneeType).add("realAssignee", this.realAssignee).add("realAssigneeType", (Object)this.realAssigneeType).add("isAssigneeTypeValid", this.isAssigneeTypeValid).toString();
        }

        public boolean equals(Object obj) {
            if (obj instanceof AssigneeInfo) {
                AssigneeInfo that = (AssigneeInfo)obj;
                return Objects.equal(this.assignee, that.assignee) && Objects.equal((Object)this.assigneeType, (Object)that.assigneeType) && Objects.equal(this.realAssignee, that.realAssignee) && Objects.equal((Object)this.realAssigneeType, (Object)that.realAssigneeType) && Objects.equal(this.isAssigneeTypeValid, that.isAssigneeTypeValid);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode(new Object[]{super.hashCode(), this.assignee, this.assigneeType, this.realAssignee, this.realAssigneeType, this.isAssigneeTypeValid});
        }
    }
}

