/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.domain;

import com.atlassian.jira.rest.client.AddressableEntity;
import com.atlassian.jira.rest.client.domain.BasicUser;
import com.google.common.base.Objects;
import java.net.URI;
import javax.annotation.Nullable;
import org.joda.time.DateTime;

public class Attachment
implements AddressableEntity {
    private final URI self;
    private final String filename;
    private final BasicUser author;
    private final DateTime creationDate;
    private final int size;
    private final String mimeType;
    private final URI contentUri;
    @Nullable
    private final URI thumbnailUri;

    public Attachment(URI self, String filename, BasicUser author, DateTime creationDate, int size, String mimeType, URI contentUri, URI thumbnailUri) {
        this.self = self;
        this.filename = filename;
        this.author = author;
        this.creationDate = creationDate;
        this.size = size;
        this.mimeType = mimeType;
        this.contentUri = contentUri;
        this.thumbnailUri = thumbnailUri;
    }

    public boolean hasThumbnail() {
        return this.thumbnailUri != null;
    }

    @Override
    public URI getSelf() {
        return this.self;
    }

    public String getFilename() {
        return this.filename;
    }

    public BasicUser getAuthor() {
        return this.author;
    }

    public DateTime getCreationDate() {
        return this.creationDate;
    }

    public int getSize() {
        return this.size;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public URI getContentUri() {
        return this.contentUri;
    }

    @Nullable
    public URI getThumbnailUri() {
        return this.thumbnailUri;
    }

    public String toString() {
        return Objects.toStringHelper(this).add("self", this.self).add("filename", this.filename).add("author", this.author).add("creationDate", this.creationDate).add("size", this.size).add("mimeType", this.mimeType).add("contentUri", this.contentUri).add("thumbnailUri", this.thumbnailUri).toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Attachment) {
            Attachment that = (Attachment)obj;
            return Objects.equal(this.self, that.self) && Objects.equal(this.filename, that.filename) && Objects.equal(this.author, that.author) && this.creationDate.isEqual(that.creationDate) && Objects.equal(this.size, that.size) && Objects.equal(this.mimeType, that.mimeType) && Objects.equal(this.contentUri, that.contentUri) && Objects.equal(this.thumbnailUri, that.thumbnailUri);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.self, this.filename, this.author, this.creationDate, this.size, this.mimeType, this.contentUri, this.thumbnailUri);
    }
}

