/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.action;

import org.springframework.binding.expression.Expression;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class FlowDefinitionRedirectAction
extends AbstractAction {
    private Expression expression;

    public FlowDefinitionRedirectAction(Expression expression) {
        Assert.notNull(expression, "The flow definition redirect expression is required");
        this.expression = expression;
    }

    protected Event doExecute(RequestContext context) throws Exception {
        String flowDefinitionId;
        String encodedRedirect = (String)this.expression.getValue(context);
        if (encodedRedirect == null) {
            throw new IllegalStateException("Flow definition redirect expression evaluated to [null], the expression was " + this.expression);
        }
        int index = encodedRedirect.indexOf(63);
        LocalAttributeMap executionInput = null;
        if (index != -1) {
            flowDefinitionId = encodedRedirect.substring(0, index);
            String[] parameters = StringUtils.delimitedListToStringArray(encodedRedirect.substring(index + 1), "&");
            executionInput = new LocalAttributeMap(parameters.length, 1);
            for (int i = 0; i < parameters.length; ++i) {
                String nameAndValue = parameters[i];
                index = nameAndValue.indexOf(61);
                if (index != -1) {
                    executionInput.put(nameAndValue.substring(0, index), nameAndValue.substring(index + 1));
                    continue;
                }
                executionInput.put(nameAndValue, "");
            }
        } else {
            flowDefinitionId = encodedRedirect;
        }
        if (!StringUtils.hasText(flowDefinitionId)) {
            flowDefinitionId = context.getFlowExecutionContext().getDefinition().getId();
        }
        context.getExternalContext().requestFlowDefinitionRedirect(flowDefinitionId, executionInput);
        return this.success();
    }
}

