/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.config;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.jms.config.AbstractListenerContainerParser;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

class JcaListenerContainerParser
extends AbstractListenerContainerParser {
    private static final String RESOURCE_ADAPTER_ATTRIBUTE = "resource-adapter";
    private static final String ACTIVATION_SPEC_FACTORY_ATTRIBUTE = "activation-spec-factory";

    JcaListenerContainerParser() {
    }

    @Override
    protected BeanDefinition parseContainer(Element listenerEle, Element containerEle, ParserContext parserContext) {
        String phase;
        String prefetch;
        String concurrency;
        String transactionManagerBeanName;
        RootBeanDefinition containerDef = new RootBeanDefinition();
        containerDef.setSource(parserContext.extractSource(containerEle));
        containerDef.setBeanClassName("org.springframework.jms.listener.endpoint.JmsMessageEndpointManager");
        if (containerEle.hasAttribute(RESOURCE_ADAPTER_ATTRIBUTE)) {
            String resourceAdapterBeanName = containerEle.getAttribute(RESOURCE_ADAPTER_ATTRIBUTE);
            if (!StringUtils.hasText(resourceAdapterBeanName)) {
                parserContext.getReaderContext().error("Listener container 'resource-adapter' attribute contains empty value.", containerEle);
            } else {
                containerDef.getPropertyValues().add("resourceAdapter", new RuntimeBeanReference(resourceAdapterBeanName));
            }
        }
        String activationSpecFactoryBeanName = containerEle.getAttribute(ACTIVATION_SPEC_FACTORY_ATTRIBUTE);
        String destinationResolverBeanName = containerEle.getAttribute("destination-resolver");
        if (StringUtils.hasText(activationSpecFactoryBeanName)) {
            if (StringUtils.hasText(destinationResolverBeanName)) {
                parserContext.getReaderContext().error("Specify either 'activation-spec-factory' or 'destination-resolver', not both. If you define a dedicated JmsActivationSpecFactory bean, specify the custom DestinationResolver there (if possible).", containerEle);
            }
            containerDef.getPropertyValues().add("activationSpecFactory", new RuntimeBeanReference(activationSpecFactoryBeanName));
        }
        if (StringUtils.hasText(destinationResolverBeanName)) {
            containerDef.getPropertyValues().add("destinationResolver", new RuntimeBeanReference(destinationResolverBeanName));
        }
        RootBeanDefinition configDef = new RootBeanDefinition();
        configDef.setSource(parserContext.extractSource(configDef));
        configDef.setBeanClassName("org.springframework.jms.listener.endpoint.JmsActivationSpecConfig");
        this.parseListenerConfiguration(listenerEle, parserContext, configDef);
        this.parseContainerConfiguration(containerEle, parserContext, configDef);
        Integer acknowledgeMode = this.parseAcknowledgeMode(containerEle, parserContext);
        if (acknowledgeMode != null) {
            configDef.getPropertyValues().add("acknowledgeMode", acknowledgeMode);
        }
        if (StringUtils.hasText(transactionManagerBeanName = containerEle.getAttribute("transaction-manager"))) {
            containerDef.getPropertyValues().add("transactionManager", new RuntimeBeanReference(transactionManagerBeanName));
        }
        if (StringUtils.hasText(concurrency = containerEle.getAttribute("concurrency"))) {
            configDef.getPropertyValues().add("concurrency", concurrency);
        }
        if (StringUtils.hasText(prefetch = containerEle.getAttribute("prefetch"))) {
            configDef.getPropertyValues().add("prefetchSize", new Integer(prefetch));
        }
        if (StringUtils.hasText(phase = containerEle.getAttribute("phase"))) {
            containerDef.getPropertyValues().add("phase", phase);
        }
        containerDef.getPropertyValues().add("activationSpecConfig", configDef);
        return containerDef;
    }

    @Override
    protected boolean indicatesPubSub(BeanDefinition containerDef) {
        BeanDefinition configDef = (BeanDefinition)containerDef.getPropertyValues().getPropertyValue("activationSpecConfig").getValue();
        return this.indicatesPubSubConfig(configDef);
    }
}

