/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.metadata;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.GroupDefinitionException;
import javax.validation.GroupSequence;
import javax.validation.Valid;
import javax.validation.groups.Default;
import javax.validation.metadata.BeanDescriptor;
import javax.validation.metadata.PropertyDescriptor;
import org.hibernate.validator.metadata.AnnotationIgnores;
import org.hibernate.validator.metadata.BeanDescriptorImpl;
import org.hibernate.validator.metadata.BeanMetaData;
import org.hibernate.validator.metadata.BeanMetaDataCache;
import org.hibernate.validator.metadata.ConstraintDescriptorImpl;
import org.hibernate.validator.metadata.ConstraintHelper;
import org.hibernate.validator.metadata.ConstraintOrigin;
import org.hibernate.validator.metadata.MetaConstraint;
import org.hibernate.validator.metadata.PropertyDescriptorImpl;
import org.hibernate.validator.util.LoggerFactory;
import org.hibernate.validator.util.ReflectionHelper;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BeanMetaDataImpl<T>
implements BeanMetaData<T> {
    private static final Logger log = LoggerFactory.make();
    private final Class<T> beanClass;
    private BeanDescriptorImpl<T> beanDescriptor;
    private Map<Class<?>, List<MetaConstraint<T, ? extends Annotation>>> metaConstraints = new HashMap();
    private List<Member> cascadedMembers = new ArrayList<Member>();
    private Map<String, PropertyDescriptor> propertyDescriptors = new HashMap<String, PropertyDescriptor>();
    private List<Class<?>> defaultGroupSequence = new ArrayList();
    private final ConstraintHelper constraintHelper;
    private final Set<String> propertyNames = new HashSet<String>(30);

    public BeanMetaDataImpl(Class<T> beanClass, ConstraintHelper constraintHelper, BeanMetaDataCache beanMetaDataCache) {
        this(beanClass, constraintHelper, new ArrayList(), new HashMap(), new ArrayList<Member>(), new AnnotationIgnores(), beanMetaDataCache);
    }

    public BeanMetaDataImpl(Class<T> beanClass, ConstraintHelper constraintHelper, List<Class<?>> defaultGroupSequence, Map<Class<?>, List<MetaConstraint<T, ?>>> constraints, List<Member> cascadedMembers, AnnotationIgnores annotationIgnores, BeanMetaDataCache beanMetaDataCache) {
        this.beanClass = beanClass;
        this.constraintHelper = constraintHelper;
        this.createMetaData(annotationIgnores, beanMetaDataCache);
        if (!defaultGroupSequence.isEmpty()) {
            this.setDefaultGroupSequence(defaultGroupSequence);
        }
        for (Map.Entry<Class<?>, List<MetaConstraint<T, ?>>> entry : constraints.entrySet()) {
            Class<?> clazz = entry.getKey();
            for (MetaConstraint<T, ?> constraint : entry.getValue()) {
                this.addMetaConstraint(clazz, constraint);
            }
        }
        for (Member member : cascadedMembers) {
            this.addCascadedMember(member);
        }
    }

    @Override
    public Class<T> getBeanClass() {
        return this.beanClass;
    }

    @Override
    public BeanDescriptor getBeanDescriptor() {
        return this.beanDescriptor;
    }

    @Override
    public List<Member> getCascadedMembers() {
        return Collections.unmodifiableList(this.cascadedMembers);
    }

    @Override
    public Map<Class<?>, List<MetaConstraint<T, ? extends Annotation>>> getMetaConstraintsAsMap() {
        return Collections.unmodifiableMap(this.metaConstraints);
    }

    @Override
    public List<MetaConstraint<T, ? extends Annotation>> getMetaConstraintsAsList() {
        ArrayList<MetaConstraint<T, ? extends Annotation>> constraintList = new ArrayList<MetaConstraint<T, ? extends Annotation>>();
        for (List<MetaConstraint<T, ? extends Annotation>> list : this.metaConstraints.values()) {
            constraintList.addAll(list);
        }
        return Collections.unmodifiableList(constraintList);
    }

    @Override
    public PropertyDescriptor getPropertyDescriptor(String property) {
        return this.propertyDescriptors.get(property);
    }

    @Override
    public boolean isPropertyPresent(String name) {
        return this.propertyNames.contains(name);
    }

    @Override
    public List<Class<?>> getDefaultGroupSequence() {
        return Collections.unmodifiableList(this.defaultGroupSequence);
    }

    @Override
    public boolean defaultGroupSequenceIsRedefined() {
        return this.defaultGroupSequence.size() > 1;
    }

    @Override
    public Set<PropertyDescriptor> getConstrainedProperties() {
        return Collections.unmodifiableSet(new HashSet<PropertyDescriptor>(this.propertyDescriptors.values()));
    }

    private void setDefaultGroupSequence(List<Class<?>> groupSequence) {
        this.defaultGroupSequence = new ArrayList();
        boolean groupSequenceContainsDefault = false;
        for (Class<?> group : groupSequence) {
            if (group.getName().equals(this.beanClass.getName())) {
                this.defaultGroupSequence.add(Default.class);
                groupSequenceContainsDefault = true;
                continue;
            }
            if (group.getName().equals(Default.class.getName())) {
                throw new GroupDefinitionException("'Default.class' cannot appear in default group sequence list.");
            }
            this.defaultGroupSequence.add(group);
        }
        if (!groupSequenceContainsDefault) {
            throw new GroupDefinitionException(this.beanClass.getName() + " must be part of the redefined default group sequence.");
        }
        if (log.isTraceEnabled()) {
            log.trace("Members of the default group sequence for bean {} are: {}", (Object)this.beanClass.getName(), (Object)this.defaultGroupSequence);
        }
    }

    private void addMetaConstraint(Class<?> clazz, MetaConstraint<T, ? extends Annotation> metaConstraint) {
        List<Object> constraintList;
        if (!this.metaConstraints.containsKey(clazz)) {
            constraintList = new ArrayList();
            this.metaConstraints.put(clazz, constraintList);
        } else {
            constraintList = this.metaConstraints.get(clazz);
        }
        constraintList.add(metaConstraint);
        if (metaConstraint.getElementType() == ElementType.TYPE) {
            this.beanDescriptor.addConstraintDescriptor(metaConstraint.getDescriptor());
        } else {
            PropertyDescriptorImpl propertyDescriptor = (PropertyDescriptorImpl)this.propertyDescriptors.get(metaConstraint.getPropertyName());
            if (propertyDescriptor == null) {
                Member member = metaConstraint.getMember();
                propertyDescriptor = this.addPropertyDescriptorForMember(member, this.isValidAnnotationPresent(member));
            }
            propertyDescriptor.addConstraintDescriptor(metaConstraint.getDescriptor());
        }
    }

    private void addCascadedMember(Member member) {
        ReflectionHelper.setAccessibility(member);
        this.cascadedMembers.add(member);
        this.addPropertyDescriptorForMember(member, true);
    }

    private void createMetaData(AnnotationIgnores annotationIgnores, BeanMetaDataCache beanMetaDataCache) {
        this.beanDescriptor = new BeanDescriptorImpl(this);
        this.initDefaultGroupSequence();
        List<Class<?>> classes = ReflectionHelper.computeClassHierarchy(this.beanClass);
        for (Class<?> current : classes) {
            this.initClass(current, annotationIgnores, beanMetaDataCache);
        }
    }

    private void initClass(Class<?> clazz, AnnotationIgnores annotationIgnores, BeanMetaDataCache beanMetaDataCache) {
        this.initClassConstraints(clazz, annotationIgnores, beanMetaDataCache);
        this.initMethodConstraints(clazz, annotationIgnores, beanMetaDataCache);
        this.initFieldConstraints(clazz, annotationIgnores, beanMetaDataCache);
    }

    private void initDefaultGroupSequence() {
        ArrayList groupSequence = new ArrayList();
        GroupSequence groupSequenceAnnotation = this.beanClass.getAnnotation(GroupSequence.class);
        if (groupSequenceAnnotation == null) {
            groupSequence.add(this.beanClass);
        } else {
            groupSequence.addAll(Arrays.asList(groupSequenceAnnotation.value()));
        }
        this.setDefaultGroupSequence(groupSequence);
    }

    private void initFieldConstraints(Class<?> clazz, AnnotationIgnores annotationIgnores, BeanMetaDataCache beanMetaDataCache) {
        Field[] fields;
        for (Field field : fields = ReflectionHelper.getFields(clazz)) {
            List<ConstraintDescriptorImpl<?>> fieldMetaData;
            this.addToPropertyNameList(field);
            if (Modifier.isStatic(field.getModifiers()) || annotationIgnores.isIgnoreAnnotations(field)) continue;
            BeanMetaDataImpl<?> cachedMetaData = beanMetaDataCache.getBeanMetaData(clazz);
            boolean cachedFieldIsCascaded = false;
            if (cachedMetaData != null && cachedMetaData.getMetaConstraintsAsMap().get(clazz) != null) {
                fieldMetaData = new ArrayList();
                cachedFieldIsCascaded = cachedMetaData.getCascadedMembers().contains(field);
                for (MetaConstraint metaConstraint : cachedMetaData.getMetaConstraintsAsMap().get(clazz)) {
                    ConstraintDescriptorImpl descriptor = metaConstraint.getDescriptor();
                    if (descriptor.getElementType() != ElementType.FIELD || !metaConstraint.getPropertyName().equals(ReflectionHelper.getPropertyName(field))) continue;
                    fieldMetaData.add(descriptor);
                }
            } else {
                fieldMetaData = this.findConstraints(field, ElementType.FIELD);
            }
            for (ConstraintDescriptorImpl<?> constraintDescriptorImpl : fieldMetaData) {
                ReflectionHelper.setAccessibility(field);
                MetaConstraint<T, ?> metaConstraint = this.createMetaConstraint(field, constraintDescriptorImpl);
                this.addMetaConstraint(clazz, metaConstraint);
            }
            if (!cachedFieldIsCascaded && !field.isAnnotationPresent(Valid.class)) continue;
            this.addCascadedMember(field);
        }
    }

    private void addToPropertyNameList(Member member) {
        String name = ReflectionHelper.getPropertyName(member);
        if (name != null) {
            this.propertyNames.add(name);
        }
    }

    private void initMethodConstraints(Class<?> clazz, AnnotationIgnores annotationIgnores, BeanMetaDataCache beanMetaDataCache) {
        Method[] declaredMethods;
        for (Method method : declaredMethods = ReflectionHelper.getMethods(clazz)) {
            List<ConstraintDescriptorImpl<?>> methodMetaData;
            this.addToPropertyNameList(method);
            if (Modifier.isStatic(method.getModifiers()) || annotationIgnores.isIgnoreAnnotations(method)) continue;
            BeanMetaDataImpl<?> cachedMetaData = beanMetaDataCache.getBeanMetaData(clazz);
            boolean cachedMethodIsCascaded = false;
            if (cachedMetaData != null && cachedMetaData.getMetaConstraintsAsMap().get(clazz) != null) {
                cachedMethodIsCascaded = cachedMetaData.getCascadedMembers().contains(method);
                methodMetaData = new ArrayList();
                for (MetaConstraint metaConstraint : cachedMetaData.getMetaConstraintsAsMap().get(clazz)) {
                    ConstraintDescriptorImpl descriptor = metaConstraint.getDescriptor();
                    if (descriptor.getElementType() != ElementType.METHOD || !metaConstraint.getPropertyName().equals(ReflectionHelper.getPropertyName(method))) continue;
                    methodMetaData.add(descriptor);
                }
            } else {
                methodMetaData = this.findConstraints(method, ElementType.METHOD);
            }
            for (ConstraintDescriptorImpl<?> constraintDescriptorImpl : methodMetaData) {
                ReflectionHelper.setAccessibility(method);
                MetaConstraint<T, ?> metaConstraint = this.createMetaConstraint(method, constraintDescriptorImpl);
                this.addMetaConstraint(clazz, metaConstraint);
            }
            if (!cachedMethodIsCascaded && !method.isAnnotationPresent(Valid.class)) continue;
            this.addCascadedMember(method);
        }
    }

    private PropertyDescriptorImpl addPropertyDescriptorForMember(Member member, boolean isCascaded) {
        String name = ReflectionHelper.getPropertyName(member);
        PropertyDescriptorImpl propertyDescriptor = (PropertyDescriptorImpl)this.propertyDescriptors.get(name);
        if (propertyDescriptor == null) {
            propertyDescriptor = new PropertyDescriptorImpl(ReflectionHelper.getType(member), isCascaded, name, this);
            this.propertyDescriptors.put(name, propertyDescriptor);
        }
        return propertyDescriptor;
    }

    private boolean isValidAnnotationPresent(Member member) {
        return ((AnnotatedElement)((Object)member)).isAnnotationPresent(Valid.class);
    }

    private void initClassConstraints(Class<?> clazz, AnnotationIgnores annotationIgnores, BeanMetaDataCache beanMetaDataCache) {
        List<ConstraintDescriptorImpl<?>> classMetaData;
        if (annotationIgnores.isIgnoreAnnotations(clazz)) {
            return;
        }
        BeanMetaDataImpl<?> cachedMetaData = beanMetaDataCache.getBeanMetaData(clazz);
        if (cachedMetaData != null && cachedMetaData.getMetaConstraintsAsMap().get(clazz) != null) {
            classMetaData = new ArrayList();
            for (MetaConstraint metaConstraint : cachedMetaData.getMetaConstraintsAsMap().get(clazz)) {
                ConstraintDescriptorImpl descriptor = metaConstraint.getDescriptor();
                if (descriptor.getElementType() != ElementType.TYPE) continue;
                classMetaData.add(descriptor);
            }
        } else {
            classMetaData = this.findClassLevelConstraints(clazz);
        }
        for (ConstraintDescriptorImpl<?> constraintDescriptorImpl : classMetaData) {
            MetaConstraint<T, ?> metaConstraint = this.createMetaConstraint(null, constraintDescriptorImpl);
            this.addMetaConstraint(clazz, metaConstraint);
        }
    }

    private <A extends Annotation> MetaConstraint<T, ?> createMetaConstraint(Member m, ConstraintDescriptorImpl<A> descriptor) {
        return new MetaConstraint<T, A>(this.beanClass, m, descriptor);
    }

    private <A extends Annotation> List<ConstraintDescriptorImpl<?>> findConstraintAnnotations(Class<?> clazz, A annotation, ElementType type) {
        ArrayList constraintDescriptors = new ArrayList();
        ArrayList<Annotation> constraints = new ArrayList<Annotation>();
        Class<? extends Annotation> annotationType = annotation.annotationType();
        if (this.constraintHelper.isConstraintAnnotation(annotationType) || this.constraintHelper.isBuiltinConstraint(annotationType)) {
            constraints.add(annotation);
        } else if (this.constraintHelper.isMultiValueConstraint(annotationType)) {
            constraints.addAll(this.constraintHelper.getMultiValueConstraints(annotation));
        }
        for (Annotation constraint : constraints) {
            ConstraintDescriptorImpl constraintDescriptor = this.buildConstraintDescriptor(clazz, constraint, type);
            constraintDescriptors.add(constraintDescriptor);
        }
        return constraintDescriptors;
    }

    private <A extends Annotation> ConstraintDescriptorImpl buildConstraintDescriptor(Class<?> clazz, A annotation, ElementType type) {
        ConstraintOrigin definedIn = this.determineOrigin(clazz);
        ConstraintDescriptorImpl<A> constraintDescriptor = clazz.isInterface() && !clazz.equals(this.beanClass) ? new ConstraintDescriptorImpl<A>(annotation, this.constraintHelper, clazz, type, definedIn) : new ConstraintDescriptorImpl<A>(annotation, this.constraintHelper, type, definedIn);
        return constraintDescriptor;
    }

    private List<ConstraintDescriptorImpl<?>> findClassLevelConstraints(Class<?> beanClass) {
        ArrayList metaData = new ArrayList();
        for (Annotation annotation : beanClass.getAnnotations()) {
            metaData.addAll(this.findConstraintAnnotations(beanClass, annotation, ElementType.TYPE));
        }
        return metaData;
    }

    private List<ConstraintDescriptorImpl<?>> findConstraints(Member member, ElementType type) {
        assert (member instanceof Field || member instanceof Method);
        ArrayList metaData = new ArrayList();
        for (Annotation annotation : ((AnnotatedElement)((Object)member)).getAnnotations()) {
            metaData.addAll(this.findConstraintAnnotations(member.getDeclaringClass(), annotation, type));
        }
        return metaData;
    }

    private ConstraintOrigin determineOrigin(Class<?> clazz) {
        if (clazz.equals(this.beanClass)) {
            return ConstraintOrigin.DEFINED_LOCALLY;
        }
        return ConstraintOrigin.DEFINED_IN_HIERARCHY;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("BeanMetaDataImpl");
        sb.append("{beanClass=").append(this.beanClass);
        sb.append(", beanDescriptor=").append(this.beanDescriptor);
        sb.append(", metaConstraints=").append(this.metaConstraints);
        sb.append(", cascadedMembers=").append(this.cascadedMembers);
        sb.append(", propertyDescriptors=").append(this.propertyDescriptors);
        sb.append(", defaultGroupSequence=").append(this.defaultGroupSequence);
        sb.append(", constraintHelper=").append(this.constraintHelper);
        sb.append('}');
        return sb.toString();
    }
}

