/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine.model;

import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.webflow.engine.model.AbstractModel;
import org.springframework.webflow.engine.model.Model;

public class SecuredModel
extends AbstractModel {
    private String attributes;
    private String match;

    public SecuredModel(String attributes) {
        this.setAttributes(attributes);
    }

    public boolean isMergeableWith(Model model) {
        if (!(model instanceof SecuredModel)) {
            return false;
        }
        SecuredModel secured = (SecuredModel)model;
        return ObjectUtils.nullSafeEquals(this.getAttributes(), secured.getAttributes());
    }

    public void merge(Model model) {
        SecuredModel secured = (SecuredModel)model;
        this.setMatch(this.merge(this.getMatch(), secured.getMatch()));
    }

    public Model createCopy() {
        SecuredModel copy = new SecuredModel(this.attributes);
        copy.setMatch(this.match);
        return copy;
    }

    public String getAttributes() {
        return this.attributes;
    }

    public void setAttributes(String attributes) {
        this.attributes = StringUtils.hasText(attributes) ? attributes : null;
    }

    public String getMatch() {
        return this.match;
    }

    public void setMatch(String match) {
        this.match = StringUtils.hasText(match) ? match : null;
    }
}

