/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.definition.TransitionDefinition;
import org.springframework.webflow.engine.ActionList;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.History;
import org.springframework.webflow.engine.RequestControlContext;
import org.springframework.webflow.engine.TransitionableState;
import org.springframework.webflow.engine.ViewRenderingException;
import org.springframework.webflow.engine.ViewVariable;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.FlowExecutionException;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.View;
import org.springframework.webflow.execution.ViewFactory;

public class ViewState
extends TransitionableState {
    private ActionList renderActionList = new ActionList();
    private ViewFactory viewFactory;
    private Map variables = new LinkedHashMap();
    private Boolean redirect;
    private boolean popup;

    public ViewState(Flow flow, String id, ViewFactory viewFactory) throws IllegalArgumentException {
        super(flow, id);
        Assert.notNull(viewFactory, "The view factory is required");
        this.viewFactory = viewFactory;
    }

    public boolean isViewState() {
        return true;
    }

    public void addVariable(ViewVariable variable) {
        this.variables.put(variable.getName(), variable);
    }

    public void addVariables(ViewVariable[] variables) {
        for (int i = 0; i < variables.length; ++i) {
            this.addVariable(variables[i]);
        }
    }

    public ViewVariable getVariable(String name) {
        return (ViewVariable)this.variables.get(name);
    }

    public ViewVariable[] getVariables() {
        return this.variables.values().toArray(new ViewVariable[this.variables.size()]);
    }

    public boolean getRedirect() {
        return this.redirect != null ? this.redirect : false;
    }

    public void setRedirect(Boolean redirect) {
        this.redirect = redirect;
    }

    public boolean getPopup() {
        return this.popup;
    }

    public void setPopup(boolean popup) {
        this.popup = popup;
    }

    public ViewFactory getViewFactory() {
        return this.viewFactory;
    }

    public ActionList getRenderActionList() {
        return this.renderActionList;
    }

    protected void doPreEntryActions(RequestControlContext context) throws FlowExecutionException {
        this.createVariables(context);
    }

    protected void doEnter(RequestControlContext context) throws FlowExecutionException {
        context.assignFlowExecutionKey();
        ExternalContext externalContext = context.getExternalContext();
        if (externalContext.isResponseComplete()) {
            if (!externalContext.isResponseCompleteFlowExecutionRedirect()) {
                this.clearFlash(context);
            }
        } else if (this.shouldRedirect(context)) {
            context.getExternalContext().requestFlowExecutionRedirect();
            if (this.popup) {
                context.getExternalContext().requestRedirectInPopup();
            }
        } else {
            View view = this.viewFactory.getView(context);
            context.setCurrentView(view);
            this.render(context, view);
        }
    }

    public void resume(RequestControlContext context) {
        this.restoreVariables(context);
        View view = this.viewFactory.getView(context);
        context.setCurrentView(view);
        if (view.userEventQueued()) {
            boolean stateExited = this.handleEvent(view, context);
            if (!stateExited) {
                ExternalContext externalContext = context.getExternalContext();
                if (externalContext.isResponseComplete()) {
                    if (externalContext.isResponseCompleteFlowExecutionRedirect()) {
                        context.getFlashScope().put("viewUserEventState", view.getUserEventState());
                    } else {
                        this.clearFlash(context);
                    }
                } else if (externalContext.isAjaxRequest()) {
                    this.render(context, view);
                } else if (this.shouldRedirectInSameState(context)) {
                    context.getFlashScope().put("viewUserEventState", view.getUserEventState());
                    externalContext.requestFlowExecutionRedirect();
                } else if (externalContext.isResponseAllowed()) {
                    this.render(context, view);
                }
            }
        } else {
            this.refresh(view, context);
        }
    }

    private boolean handleEvent(View view, RequestControlContext context) {
        view.processUserEvent();
        if (view.hasFlowEvent()) {
            Event event = view.getFlowEvent();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Event '" + event.getId() + "' returned from view " + view);
            }
            return context.handleEvent(event);
        }
        return false;
    }

    private void refresh(View view, RequestControlContext context) {
        ExternalContext externalContext = context.getExternalContext();
        if (externalContext.isResponseComplete()) {
            this.clearFlash(context);
        } else {
            this.render(context, view);
        }
    }

    public void exit(RequestControlContext context) {
        super.exit(context);
        this.updateHistory(context);
        this.destroyVariables(context);
        context.setCurrentView(null);
    }

    private void createVariables(RequestContext context) {
        for (ViewVariable variable : this.variables.values()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Creating " + variable);
            }
            variable.create(context);
        }
    }

    private boolean shouldRedirect(RequestControlContext context) {
        if (this.redirect != null) {
            return this.redirect;
        }
        if (context.getExternalContext().isAjaxRequest() && context.getEmbeddedMode()) {
            return false;
        }
        return context.getRedirectOnPause();
    }

    private boolean shouldRedirectInSameState(RequestControlContext context) {
        if (this.redirect != null) {
            return this.redirect;
        }
        if (context.getExternalContext().isAjaxRequest() && context.getEmbeddedMode()) {
            return false;
        }
        return context.getRedirectInSameState();
    }

    private void render(RequestControlContext context, View view) throws ViewRenderingException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Rendering + " + view);
            this.logger.debug("  Flash scope = " + context.getFlashScope());
            this.logger.debug("  Messages = " + context.getMessageContext());
        }
        context.viewRendering(view);
        this.renderActionList.execute(context);
        try {
            view.render();
        }
        catch (IOException e) {
            throw new ViewRenderingException(this.getOwner().getId(), this.getId(), view, (Throwable)e);
        }
        this.clearFlash(context);
        context.getExternalContext().recordResponseComplete();
        context.viewRendered(view);
    }

    private void clearFlash(RequestContext context) {
        context.getFlashScope().clear();
        context.getMessageContext().clearMessages();
    }

    private void restoreVariables(RequestContext context) {
        for (ViewVariable variable : this.variables.values()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Restoring " + variable);
            }
            variable.restore(context);
        }
    }

    private void updateHistory(RequestControlContext context) {
        TransitionDefinition transition = context.getCurrentTransition();
        History history = (History)((Object)transition.getAttributes().get("history"));
        if (history == null || history == History.PRESERVE) {
            View currentView = context.getCurrentView();
            if (currentView != null && this.shouldRedirect(context)) {
                currentView.saveState();
            }
            context.updateCurrentFlowExecutionSnapshot();
        } else if (history == History.DISCARD) {
            context.removeCurrentFlowExecutionSnapshot();
        } else if (history == History.INVALIDATE) {
            context.removeAllFlowExecutionSnapshots();
        }
    }

    private void destroyVariables(RequestContext context) {
        for (ViewVariable variable : this.variables.values()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Destroying " + variable);
            }
            variable.destroy(context);
        }
    }

    protected void appendToString(ToStringCreator creator) {
        super.appendToString(creator);
        creator.append("viewFactory", this.viewFactory).append("variables", this.variables).append("redirect", this.redirect).append("popup", this.popup);
    }
}

