/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.expression.spel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.binding.convert.ConversionService;
import org.springframework.binding.convert.service.DefaultConversionService;
import org.springframework.binding.expression.Expression;
import org.springframework.binding.expression.ExpressionParser;
import org.springframework.binding.expression.ExpressionVariable;
import org.springframework.binding.expression.ParserContext;
import org.springframework.binding.expression.ParserException;
import org.springframework.binding.expression.spel.SpringELExpression;
import org.springframework.binding.expression.support.NullParserContext;
import org.springframework.context.expression.MapAccessor;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.util.Assert;

public class SpringELExpressionParser
implements ExpressionParser {
    private SpelExpressionParser expressionParser;
    private ConversionService conversionService;
    private List<PropertyAccessor> propertyAccessors = new ArrayList<PropertyAccessor>();

    public SpringELExpressionParser(SpelExpressionParser expressionParser) {
        this(expressionParser, new DefaultConversionService());
    }

    public SpringELExpressionParser(SpelExpressionParser expressionParser, ConversionService conversionService) {
        this.expressionParser = expressionParser;
        this.propertyAccessors.add(new MapAccessor());
        this.conversionService = conversionService;
    }

    public ConversionService getConversionService() {
        return this.conversionService;
    }

    public void addPropertyAccessor(PropertyAccessor propertyAccessor) {
        this.propertyAccessors.add(propertyAccessor);
    }

    public Expression parseExpression(String expressionString, ParserContext parserContext) throws ParserException {
        Assert.hasText(expressionString, "The expression string to parse is required and must not be empty");
        parserContext = parserContext == null ? NullParserContext.INSTANCE : parserContext;
        Map spelExpressionVariables = this.parseSpelExpressionVariables(parserContext.getExpressionVariables());
        return new SpringELExpression(this.parseSpelExpression(expressionString, parserContext), spelExpressionVariables, parserContext.getExpectedEvaluationResultType(), this.conversionService.getDelegateConversionService(), this.propertyAccessors);
    }

    private org.springframework.expression.Expression parseSpelExpression(String expression, ParserContext parserContext) {
        return this.expressionParser.parseExpression(expression, this.getSpelParserContext(parserContext));
    }

    private org.springframework.expression.ParserContext getSpelParserContext(ParserContext parserContext) {
        return parserContext.isTemplate() ? org.springframework.expression.ParserContext.TEMPLATE_EXPRESSION : null;
    }

    private Map parseSpelExpressionVariables(ExpressionVariable[] expressionVariables) {
        if (expressionVariables == null || expressionVariables.length == 0) {
            return null;
        }
        HashMap<String, Expression> spelExpressionVariables = new HashMap<String, Expression>(expressionVariables.length);
        for (int i = 0; i < expressionVariables.length; ++i) {
            ExpressionVariable var = expressionVariables[i];
            spelExpressionVariables.put(var.getName(), this.parseExpression(var.getValueExpression(), var.getParserContext()));
        }
        return spelExpressionVariables;
    }
}

