/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.cfg.ObjectNameNormalizer;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.TransactionHelper;
import org.hibernate.id.Configurable;
import org.hibernate.id.IdentifierGenerationException;
import org.hibernate.id.IdentifierGeneratorHelper;
import org.hibernate.id.IntegralDataTypeHolder;
import org.hibernate.id.PersistentIdentifierGenerator;
import org.hibernate.jdbc.util.FormatStyle;
import org.hibernate.mapping.Table;
import org.hibernate.type.Type;
import org.hibernate.util.PropertiesHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableGenerator
extends TransactionHelper
implements PersistentIdentifierGenerator,
Configurable {
    public static final String COLUMN = "column";
    public static final String DEFAULT_COLUMN_NAME = "next_hi";
    public static final String TABLE = "table";
    public static final String DEFAULT_TABLE_NAME = "hibernate_unique_key";
    private static final Logger log = LoggerFactory.getLogger(TableGenerator.class);
    private Type identifierType;
    private String tableName;
    private String columnName;
    private String query;
    private String update;

    public void configure(Type type, Properties params, Dialect dialect) {
        this.identifierType = type;
        ObjectNameNormalizer normalizer = (ObjectNameNormalizer)params.get("identifier_normalizer");
        this.tableName = PropertiesHelper.getString(TABLE, params, DEFAULT_TABLE_NAME);
        if (this.tableName.indexOf(46) < 0) {
            String schemaName = normalizer.normalizeIdentifierQuoting(params.getProperty("schema"));
            String catalogName = normalizer.normalizeIdentifierQuoting(params.getProperty("catalog"));
            this.tableName = Table.qualify(dialect.quote(catalogName), dialect.quote(schemaName), dialect.quote(this.tableName));
        }
        this.columnName = dialect.quote(normalizer.normalizeIdentifierQuoting(PropertiesHelper.getString(COLUMN, params, DEFAULT_COLUMN_NAME)));
        this.query = "select " + this.columnName + " from " + dialect.appendLockHint(LockMode.PESSIMISTIC_WRITE, this.tableName) + dialect.getForUpdateString();
        this.update = "update " + this.tableName + " set " + this.columnName + " = ? where " + this.columnName + " = ?";
    }

    public synchronized Serializable generate(SessionImplementor session, Object object) {
        return this.generateHolder(session).makeValue();
    }

    protected IntegralDataTypeHolder generateHolder(SessionImplementor session) {
        return (IntegralDataTypeHolder)this.doWorkInNewTransaction(session);
    }

    public String[] sqlCreateStrings(Dialect dialect) throws HibernateException {
        return new String[]{dialect.getCreateTableString() + " " + this.tableName + " ( " + this.columnName + " " + dialect.getTypeName(4) + " )", "insert into " + this.tableName + " values ( 0 )"};
    }

    public String[] sqlDropStrings(Dialect dialect) {
        StringBuffer sqlDropString = new StringBuffer("drop table ");
        if (dialect.supportsIfExistsBeforeTableName()) {
            sqlDropString.append("if exists ");
        }
        sqlDropString.append(this.tableName).append(dialect.getCascadeConstraintsString());
        if (dialect.supportsIfExistsAfterTableName()) {
            sqlDropString.append(" if exists");
        }
        return new String[]{sqlDropString.toString()};
    }

    public Object generatorKey() {
        return this.tableName;
    }

    public Serializable doWorkInCurrentTransaction(Connection conn, String sql) throws SQLException {
        int rows;
        IntegralDataTypeHolder value = this.buildHolder();
        do {
            Object var11_9;
            Object var9_8;
            sql = this.query;
            SQL_STATEMENT_LOGGER.logStatement(sql, FormatStyle.BASIC);
            PreparedStatement qps = conn.prepareStatement(this.query);
            try {
                try {
                    ResultSet rs = qps.executeQuery();
                    if (!rs.next()) {
                        String err = "could not read a hi value - you need to populate the table: " + this.tableName;
                        log.error(err);
                        throw new IdentifierGenerationException(err);
                    }
                    value.initialize(rs, 1L);
                    rs.close();
                }
                catch (SQLException sqle) {
                    log.error("could not read a hi value", sqle);
                    throw sqle;
                }
                var9_8 = null;
            }
            catch (Throwable throwable) {
                var9_8 = null;
                qps.close();
                throw throwable;
            }
            qps.close();
            sql = this.update;
            SQL_STATEMENT_LOGGER.logStatement(sql, FormatStyle.BASIC);
            PreparedStatement ups = conn.prepareStatement(this.update);
            try {
                try {
                    value.copy().increment().bind(ups, 1);
                    value.bind(ups, 2);
                    rows = ups.executeUpdate();
                }
                catch (SQLException sqle) {
                    log.error("could not update hi value in: " + this.tableName, sqle);
                    throw sqle;
                }
                var11_9 = null;
            }
            catch (Throwable throwable) {
                var11_9 = null;
                ups.close();
                throw throwable;
            }
            ups.close();
        } while (rows == 0);
        return value;
    }

    protected IntegralDataTypeHolder buildHolder() {
        return IdentifierGeneratorHelper.getIntegralDataTypeHolder(this.identifierType.getReturnedClass());
    }
}

