/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine.model.registry;

import java.util.Map;
import java.util.TreeMap;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.webflow.engine.model.FlowModel;
import org.springframework.webflow.engine.model.registry.FlowModelHolder;
import org.springframework.webflow.engine.model.registry.FlowModelRegistry;
import org.springframework.webflow.engine.model.registry.NoSuchFlowModelException;

public class FlowModelRegistryImpl
implements FlowModelRegistry {
    private Map flowModels = new TreeMap();
    private FlowModelRegistry parent;

    public FlowModel getFlowModel(String id) throws NoSuchFlowModelException {
        try {
            return this.getFlowModelHolder(id).getFlowModel();
        }
        catch (NoSuchFlowModelException e) {
            if (this.parent != null) {
                return this.parent.getFlowModel(id);
            }
            throw e;
        }
    }

    public void setParent(FlowModelRegistry parent) {
        this.parent = parent;
    }

    public void registerFlowModel(String id, FlowModelHolder modelHolder) {
        Assert.notNull(modelHolder, "The holder of the flow model to register is required");
        this.flowModels.put(id, modelHolder);
    }

    private FlowModelHolder getFlowModelHolder(String id) throws NoSuchFlowModelException {
        FlowModelHolder holder = (FlowModelHolder)this.flowModels.get(id);
        if (holder == null) {
            throw new NoSuchFlowModelException(id);
        }
        return holder;
    }

    public String toString() {
        return new ToStringCreator(this).append("flowModels", this.flowModels).append("parent", this.parent).toString();
    }
}

