/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine.support;

import org.springframework.binding.expression.Expression;
import org.springframework.binding.expression.support.StaticExpression;
import org.springframework.util.Assert;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.State;
import org.springframework.webflow.engine.TargetStateResolver;
import org.springframework.webflow.engine.Transition;
import org.springframework.webflow.execution.RequestContext;

public class DefaultTargetStateResolver
implements TargetStateResolver {
    private Expression targetStateIdExpression;

    public DefaultTargetStateResolver(String targetStateId) {
        this(new StaticExpression(targetStateId));
    }

    public DefaultTargetStateResolver(Expression targetStateIdExpression) {
        Assert.notNull(targetStateIdExpression, "The target state id expression is required");
        this.targetStateIdExpression = targetStateIdExpression;
    }

    public State resolveTargetState(Transition transition, State sourceState, RequestContext context) {
        String targetStateId = (String)this.targetStateIdExpression.getValue(context);
        if (targetStateId != null) {
            return ((Flow)context.getActiveFlow()).getStateInstance(targetStateId);
        }
        return null;
    }

    public String toString() {
        return this.targetStateIdExpression.toString();
    }
}

