/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.config.annotation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import javax.servlet.ServletContext;
import org.springframework.context.ApplicationContext;
import org.springframework.util.Assert;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistration;
import org.springframework.web.servlet.handler.AbstractHandlerMapping;
import org.springframework.web.servlet.handler.SimpleUrlHandlerMapping;
import org.springframework.web.servlet.resource.ResourceHttpRequestHandler;

public class ResourceHandlerRegistry {
    private final ServletContext servletContext;
    private final ApplicationContext applicationContext;
    private final List<ResourceHandlerRegistration> registrations = new ArrayList<ResourceHandlerRegistration>();
    private int order = 0x7FFFFFFE;

    public ResourceHandlerRegistry(ApplicationContext applicationContext, ServletContext servletContext) {
        Assert.notNull(applicationContext, "ApplicationContext is required");
        this.applicationContext = applicationContext;
        this.servletContext = servletContext;
    }

    public ResourceHandlerRegistration addResourceHandler(String ... pathPatterns) {
        ResourceHandlerRegistration registration = new ResourceHandlerRegistration(this.applicationContext, pathPatterns);
        this.registrations.add(registration);
        return registration;
    }

    public boolean hasMappingForPattern(String pathPattern) {
        for (ResourceHandlerRegistration registration : this.registrations) {
            if (!Arrays.asList(registration.getPathPatterns()).contains(pathPattern)) continue;
            return true;
        }
        return false;
    }

    public ResourceHandlerRegistry setOrder(int order) {
        this.order = order;
        return this;
    }

    protected AbstractHandlerMapping getHandlerMapping() {
        if (this.registrations.isEmpty()) {
            return null;
        }
        LinkedHashMap<String, ResourceHttpRequestHandler> urlMap = new LinkedHashMap<String, ResourceHttpRequestHandler>();
        for (ResourceHandlerRegistration registration : this.registrations) {
            for (String pathPattern : registration.getPathPatterns()) {
                ResourceHttpRequestHandler requestHandler = registration.getRequestHandler();
                requestHandler.setServletContext(this.servletContext);
                requestHandler.setApplicationContext(this.applicationContext);
                urlMap.put(pathPattern, requestHandler);
            }
        }
        SimpleUrlHandlerMapping handlerMapping = new SimpleUrlHandlerMapping();
        handlerMapping.setOrder(this.order);
        handlerMapping.setUrlMap(urlMap);
        return handlerMapping;
    }
}

