/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client;

import java.io.IOException;
import java.net.URI;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.Configurable;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.AbstractHttpClient;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.protocol.HttpContext;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequest;
import org.springframework.http.client.HttpComponentsStreamingClientHttpRequest;
import org.springframework.util.Assert;

public class HttpComponentsClientHttpRequestFactory
implements ClientHttpRequestFactory,
DisposableBean {
    private CloseableHttpClient httpClient;
    private int connectTimeout;
    private int socketTimeout;
    private boolean bufferRequestBody = true;

    public HttpComponentsClientHttpRequestFactory() {
        this((HttpClient)HttpClients.createSystem());
    }

    public HttpComponentsClientHttpRequestFactory(HttpClient httpClient) {
        Assert.notNull(httpClient, "'httpClient' must not be null");
        Assert.isInstanceOf(CloseableHttpClient.class, httpClient, "'httpClient' is not of type CloseableHttpClient");
        this.httpClient = (CloseableHttpClient)httpClient;
    }

    public void setHttpClient(HttpClient httpClient) {
        Assert.isInstanceOf(CloseableHttpClient.class, httpClient, "'httpClient' is not of type CloseableHttpClient");
        this.httpClient = (CloseableHttpClient)httpClient;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setConnectTimeout(int timeout) {
        Assert.isTrue(timeout >= 0, "Timeout must be a non-negative value");
        this.connectTimeout = timeout;
        this.setLegacyConnectionTimeout(this.getHttpClient(), timeout);
    }

    private void setLegacyConnectionTimeout(HttpClient client, int timeout) {
        if (AbstractHttpClient.class.isInstance(client)) {
            client.getParams().setIntParameter("http.connection.timeout", timeout);
        }
    }

    public void setReadTimeout(int timeout) {
        Assert.isTrue(timeout >= 0, "Timeout must be a non-negative value");
        this.socketTimeout = timeout;
        this.setLegacySocketTimeout(this.getHttpClient(), timeout);
    }

    private void setLegacySocketTimeout(HttpClient client, int timeout) {
        if (AbstractHttpClient.class.isInstance(client)) {
            client.getParams().setIntParameter("http.socket.timeout", timeout);
        }
    }

    public void setBufferRequestBody(boolean bufferRequestBody) {
        this.bufferRequestBody = bufferRequestBody;
    }

    @Override
    public ClientHttpRequest createRequest(URI uri, HttpMethod httpMethod) throws IOException {
        CloseableHttpClient client = (CloseableHttpClient)this.getHttpClient();
        Assert.state(client != null, "Synchronous execution requires an HttpClient to be set");
        HttpUriRequest httpRequest = this.createHttpUriRequest(httpMethod, uri);
        this.postProcessHttpRequest(httpRequest);
        HttpContext context = this.createHttpContext(httpMethod, uri);
        if (context == null) {
            context = HttpClientContext.create();
        }
        if (context.getAttribute("http.request-config") == null) {
            RequestConfig config = null;
            if (httpRequest instanceof Configurable) {
                config = ((Configurable)httpRequest).getConfig();
            }
            if (config == null) {
                config = this.socketTimeout > 0 || this.connectTimeout > 0 ? RequestConfig.custom().setConnectTimeout(this.connectTimeout).setSocketTimeout(this.socketTimeout).build() : RequestConfig.DEFAULT;
            }
            context.setAttribute("http.request-config", (Object)config);
        }
        if (this.bufferRequestBody) {
            return new HttpComponentsClientHttpRequest(client, httpRequest, context);
        }
        return new HttpComponentsStreamingClientHttpRequest(client, httpRequest, context);
    }

    protected HttpUriRequest createHttpUriRequest(HttpMethod httpMethod, URI uri) {
        switch (httpMethod) {
            case GET: {
                return new HttpGet(uri);
            }
            case DELETE: {
                return new HttpDelete(uri);
            }
            case HEAD: {
                return new HttpHead(uri);
            }
            case OPTIONS: {
                return new HttpOptions(uri);
            }
            case POST: {
                return new HttpPost(uri);
            }
            case PUT: {
                return new HttpPut(uri);
            }
            case TRACE: {
                return new HttpTrace(uri);
            }
            case PATCH: {
                return new HttpPatch(uri);
            }
        }
        throw new IllegalArgumentException("Invalid HTTP method: " + (Object)((Object)httpMethod));
    }

    protected void postProcessHttpRequest(HttpUriRequest request) {
    }

    protected HttpContext createHttpContext(HttpMethod httpMethod, URI uri) {
        return null;
    }

    @Override
    public void destroy() throws Exception {
        this.httpClient.close();
    }
}

