/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache.ehcache;

import java.util.Collection;
import java.util.LinkedHashSet;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Status;
import org.springframework.cache.Cache;
import org.springframework.cache.ehcache.EhCacheCache;
import org.springframework.cache.transaction.AbstractTransactionSupportingCacheManager;
import org.springframework.util.Assert;

public class EhCacheCacheManager
extends AbstractTransactionSupportingCacheManager {
    private CacheManager cacheManager;

    public EhCacheCacheManager() {
    }

    public EhCacheCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    protected Collection<Cache> loadCaches() {
        CacheManager cacheManager = this.getCacheManager();
        Assert.notNull(cacheManager, "A backing EhCache CacheManager is required");
        Status status = cacheManager.getStatus();
        Assert.isTrue(Status.STATUS_ALIVE.equals(status), "An 'alive' EhCache CacheManager is required - current cache is " + status.toString());
        String[] names = cacheManager.getCacheNames();
        LinkedHashSet<Cache> caches = new LinkedHashSet<Cache>(names.length);
        for (String name : names) {
            caches.add(new EhCacheCache(cacheManager.getEhcache(name)));
        }
        return caches;
    }

    @Override
    public Cache getCache(String name) {
        Ehcache ehcache;
        Cache cache = super.getCache(name);
        if (cache == null && (ehcache = this.getCacheManager().getEhcache(name)) != null) {
            this.addCache(new EhCacheCache(ehcache));
            cache = super.getCache(name);
        }
        return cache;
    }
}

