/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.method;

import org.springframework.binding.expression.Expression;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class Parameter {
    private Class type;
    private Expression name;

    public Parameter(Class type, Expression name) {
        Assert.notNull(name, "The parameter name expression is required");
        this.type = type;
        this.name = name;
    }

    public Class getType() {
        return this.type;
    }

    public Expression getName() {
        return this.name;
    }

    public Object evaluateArgument(Object argumentSource) {
        return this.name.getValue(argumentSource);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Parameter)) {
            return false;
        }
        Parameter other = (Parameter)obj;
        return ObjectUtils.nullSafeEquals(this.type, other.type) && this.name.equals(other.name);
    }

    public int hashCode() {
        return (this.type != null ? this.type.hashCode() : 0) + this.name.hashCode();
    }

    public String toString() {
        return new ToStringCreator(this).append("type", this.type).append("name", this.name).toString();
    }
}

