/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.ap;

import java.text.MessageFormat;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import org.hibernate.validator.ap.ConstraintAnnotationVisitor;
import org.hibernate.validator.ap.util.AnnotationApiHelper;
import org.hibernate.validator.ap.util.MessagerAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SupportedAnnotationTypes(value={"*"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
@SupportedOptions(value={"diagnosticKind", "verbose"})
public class ConstraintValidationProcessor
extends AbstractProcessor {
    public static final String DIAGNOSTIC_KIND_PROCESSOR_OPTION_NAME = "diagnosticKind";
    public static final String VERBOSE_PROCESSOR_OPTION_NAME = "verbose";
    public static final Diagnostic.Kind DEFAULT_DIAGNOSTIC_KIND = Diagnostic.Kind.ERROR;
    private static final boolean ANNOTATIONS_CLAIMED_EXCLUSIVELY = false;
    private MessagerAdapter messager;
    private boolean verbose;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.verbose = this.isVerbose();
        this.messager = new MessagerAdapter(processingEnv.getMessager(), this.getDiagnosticKind());
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnvironment) {
        AnnotationApiHelper typeHelper = new AnnotationApiHelper(this.processingEnv.getElementUtils(), this.processingEnv.getTypeUtils());
        ConstraintAnnotationVisitor visitor = new ConstraintAnnotationVisitor(this.processingEnv, this.messager, this.verbose);
        for (TypeElement typeElement : annotations) {
            Set<? extends Element> elementsWithConstraintAnnotation = roundEnvironment.getElementsAnnotatedWith(typeElement);
            for (Element element : elementsWithConstraintAnnotation) {
                List<AnnotationMirror> mirrorsOfCurrentAnnotation = typeHelper.filterByType(element.getAnnotationMirrors(), typeElement.asType());
                element.accept(visitor, mirrorsOfCurrentAnnotation);
            }
        }
        return false;
    }

    private Diagnostic.Kind getDiagnosticKind() {
        String diagnosticKindFromOptions = this.processingEnv.getOptions().get(DIAGNOSTIC_KIND_PROCESSOR_OPTION_NAME);
        if (diagnosticKindFromOptions != null) {
            try {
                return Diagnostic.Kind.valueOf(diagnosticKindFromOptions);
            }
            catch (IllegalArgumentException e) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, MessageFormat.format("The given value {0} is no valid diagnostic kind. {1} will be used.", new Object[]{diagnosticKindFromOptions, DEFAULT_DIAGNOSTIC_KIND}));
            }
        }
        return DEFAULT_DIAGNOSTIC_KIND;
    }

    private boolean isVerbose() {
        boolean theValue = Boolean.parseBoolean(this.processingEnv.getOptions().get(VERBOSE_PROCESSOR_OPTION_NAME));
        if (theValue) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, MessageFormat.format("Verbose reporting is activated. Some processing information will be displayed using diagnostic kind {0}.", new Object[]{Diagnostic.Kind.NOTE}));
        }
        return theValue;
    }
}

