/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine.model;

import java.util.LinkedList;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.webflow.engine.model.AbstractModel;
import org.springframework.webflow.engine.model.Model;
import org.springframework.webflow.engine.model.SecuredModel;

public class TransitionModel
extends AbstractModel {
    private String on;
    private String onException;
    private String to;
    private String bind;
    private String validate;
    private String history;
    private LinkedList attributes;
    private SecuredModel secured;
    private LinkedList actions;

    public boolean isMergeableWith(Model model) {
        if (!(model instanceof TransitionModel)) {
            return false;
        }
        TransitionModel transition = (TransitionModel)model;
        return ObjectUtils.nullSafeEquals(this.getOn(), transition.getOn()) && ObjectUtils.nullSafeEquals(this.getOnException(), transition.getOnException());
    }

    public void merge(Model model) {
        TransitionModel transition = (TransitionModel)model;
        this.setOnException(this.merge(this.getOnException(), transition.getOnException()));
        this.setTo(this.merge(this.getTo(), transition.getTo()));
        this.setBind(this.merge(this.getBind(), transition.getBind()));
        this.setValidate(this.merge(this.getValidate(), transition.getValidate()));
        this.setHistory(this.merge(this.getHistory(), transition.getHistory()));
        this.setAttributes(this.merge(this.getAttributes(), transition.getAttributes()));
        this.setSecured((SecuredModel)this.merge(this.getSecured(), transition.getSecured()));
        this.setActions(this.merge(this.getActions(), transition.getActions(), false));
    }

    public Model createCopy() {
        TransitionModel copy = new TransitionModel();
        copy.setOn(this.on);
        copy.setOnException(this.onException);
        copy.setTo(this.to);
        copy.setBind(this.bind);
        copy.setValidate(this.validate);
        copy.setHistory(this.history);
        copy.setAttributes(this.copyList(this.attributes));
        copy.setSecured((SecuredModel)this.copy(this.secured));
        copy.setActions(this.copyList(this.actions));
        return copy;
    }

    public String getOn() {
        return this.on;
    }

    public void setOn(String on) {
        this.on = StringUtils.hasText(on) ? on : null;
    }

    public String getOnException() {
        return this.onException;
    }

    public void setOnException(String onException) {
        this.onException = StringUtils.hasText(onException) ? onException : null;
    }

    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = StringUtils.hasText(to) ? to : null;
    }

    public String getBind() {
        return this.bind;
    }

    public void setBind(String bind) {
        this.bind = StringUtils.hasText(bind) ? bind : null;
    }

    public String getValidate() {
        return this.validate;
    }

    public void setValidate(String validate) {
        this.validate = StringUtils.hasText(validate) ? validate : null;
    }

    public String getHistory() {
        return this.history;
    }

    public void setHistory(String history) {
        this.history = StringUtils.hasText(history) ? history : null;
    }

    public LinkedList getAttributes() {
        return this.attributes;
    }

    public void setAttributes(LinkedList attributes) {
        this.attributes = attributes;
    }

    public SecuredModel getSecured() {
        return this.secured;
    }

    public void setSecured(SecuredModel secured) {
        this.secured = secured;
    }

    public LinkedList getActions() {
        return this.actions;
    }

    public void setActions(LinkedList actions2) {
        this.actions = actions2;
    }
}

