/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.binding.mapping.Mapper;
import org.springframework.binding.mapping.MappingResults;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.style.StylerUtils;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.webflow.core.AnnotatedObject;
import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.definition.FlowDefinition;
import org.springframework.webflow.definition.StateDefinition;
import org.springframework.webflow.definition.TransitionDefinition;
import org.springframework.webflow.engine.ActionList;
import org.springframework.webflow.engine.EndState;
import org.springframework.webflow.engine.FlowExecutionExceptionHandlerSet;
import org.springframework.webflow.engine.FlowInputMappingException;
import org.springframework.webflow.engine.FlowOutputMappingException;
import org.springframework.webflow.engine.FlowVariable;
import org.springframework.webflow.engine.NoMatchingTransitionException;
import org.springframework.webflow.engine.RequestControlContext;
import org.springframework.webflow.engine.State;
import org.springframework.webflow.engine.Transition;
import org.springframework.webflow.engine.TransitionSet;
import org.springframework.webflow.engine.TransitionableState;
import org.springframework.webflow.engine.ViewState;
import org.springframework.webflow.execution.FlowExecutionException;
import org.springframework.webflow.execution.RequestContext;

public class Flow
extends AnnotatedObject
implements FlowDefinition {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private String id;
    private Set states = new LinkedHashSet(9);
    private State startState;
    private Map variables = new LinkedHashMap();
    private Mapper inputMapper;
    private ActionList startActionList = new ActionList();
    private TransitionSet globalTransitionSet = new TransitionSet();
    private ActionList endActionList = new ActionList();
    private Mapper outputMapper;
    private FlowExecutionExceptionHandlerSet exceptionHandlerSet = new FlowExecutionExceptionHandlerSet();
    private ApplicationContext applicationContext;

    public Flow(String id) {
        Assert.hasText(id, "This flow must be uniquely identified");
        this.id = id;
    }

    public static Flow create(String id, AttributeMap attributes) {
        Flow flow = new Flow(id);
        flow.getAttributes().putAll(attributes);
        return flow;
    }

    public String getId() {
        return this.id;
    }

    public StateDefinition getStartState() {
        if (this.startState == null) {
            throw new IllegalStateException("No start state has been set for this flow ('" + this.getId() + "') -- flow builder configuration error?");
        }
        return this.startState;
    }

    public StateDefinition getState(String stateId) {
        return this.getStateInstance(stateId);
    }

    public String[] getPossibleOutcomes() {
        ArrayList<String> possibleOutcomes = new ArrayList<String>();
        for (State state : this.states) {
            if (!(state instanceof EndState)) continue;
            possibleOutcomes.add(state.getId());
        }
        return possibleOutcomes.toArray(new String[possibleOutcomes.size()]);
    }

    public ClassLoader getClassLoader() {
        if (this.applicationContext != null) {
            return this.applicationContext.getClassLoader();
        }
        return ClassUtils.getDefaultClassLoader();
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public boolean inDevelopment() {
        return this.getAttributes().getBoolean("development", Boolean.FALSE);
    }

    protected void add(State state) throws IllegalArgumentException {
        if (this != state.getFlow() && state.getFlow() != null) {
            throw new IllegalArgumentException("State " + state + " cannot be added to this flow '" + this.getId() + "' -- it already belongs to a different flow: '" + state.getFlow().getId() + "'");
        }
        if (this.states.contains(state) || this.containsState(state.getId())) {
            throw new IllegalArgumentException("This flow '" + this.getId() + "' already contains a state with id '" + state.getId() + "' -- state ids must be locally unique to the flow definition; " + "existing state-ids of this flow include: " + StylerUtils.style(this.getStateIds()));
        }
        boolean firstAdd = this.states.isEmpty();
        this.states.add(state);
        if (firstAdd) {
            this.setStartState(state);
        }
    }

    public int getStateCount() {
        return this.states.size();
    }

    public boolean containsState(String stateId) {
        for (State state : this.states) {
            if (!state.getId().equals(stateId)) continue;
            return true;
        }
        return false;
    }

    public void setStartState(String stateId) throws IllegalArgumentException {
        this.setStartState(this.getStateInstance(stateId));
    }

    public void setStartState(State state) throws IllegalArgumentException {
        if (!this.states.contains(state)) {
            throw new IllegalArgumentException("State '" + state + "' is not a state of flow '" + this.getId() + "'");
        }
        this.startState = state;
    }

    public TransitionableState getTransitionableState(String stateId) throws IllegalArgumentException, ClassCastException {
        State state = this.getStateInstance(stateId);
        if (state != null && !(state instanceof TransitionableState)) {
            throw new ClassCastException("The state '" + stateId + "' of flow '" + this.getId() + "' must be transitionable");
        }
        return (TransitionableState)state;
    }

    public State getStateInstance(String stateId) throws IllegalArgumentException {
        if (!StringUtils.hasText(stateId)) {
            throw new IllegalArgumentException("The specified stateId is invalid: state identifiers must be non-blank");
        }
        for (State state : this.states) {
            if (!state.getId().equals(stateId)) continue;
            return state;
        }
        throw new IllegalArgumentException("Cannot find state with id '" + stateId + "' in flow '" + this.getId() + "' -- " + "Known state ids are '" + StylerUtils.style(this.getStateIds()) + "'");
    }

    public String[] getStateIds() {
        String[] stateIds = new String[this.getStateCount()];
        int i = 0;
        Iterator it = this.states.iterator();
        while (it.hasNext()) {
            stateIds[i++] = ((State)it.next()).getId();
        }
        return stateIds;
    }

    public void addVariable(FlowVariable variable) {
        this.variables.put(variable.getName(), variable);
    }

    public void addVariables(FlowVariable[] variables) {
        if (variables == null) {
            return;
        }
        for (int i = 0; i < variables.length; ++i) {
            this.addVariable(variables[i]);
        }
    }

    public FlowVariable getVariable(String name) {
        return (FlowVariable)this.variables.get(name);
    }

    public FlowVariable[] getVariables() {
        return this.variables.values().toArray(new FlowVariable[this.variables.size()]);
    }

    public Mapper getInputMapper() {
        return this.inputMapper;
    }

    public void setInputMapper(Mapper inputMapper) {
        this.inputMapper = inputMapper;
    }

    public ActionList getStartActionList() {
        return this.startActionList;
    }

    public ActionList getEndActionList() {
        return this.endActionList;
    }

    public Mapper getOutputMapper() {
        return this.outputMapper;
    }

    public void setOutputMapper(Mapper outputMapper) {
        this.outputMapper = outputMapper;
    }

    public FlowExecutionExceptionHandlerSet getExceptionHandlerSet() {
        return this.exceptionHandlerSet;
    }

    public TransitionSet getGlobalTransitionSet() {
        return this.globalTransitionSet;
    }

    public TransitionDefinition getGlobalTransition(String eventId) {
        Iterator it = this.globalTransitionSet.iterator();
        while (it.hasNext()) {
            Transition transition = (Transition)it.next();
            if (!transition.getId().equals(eventId)) continue;
            return transition;
        }
        return null;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Flow)) {
            return false;
        }
        Flow other = (Flow)o;
        return this.id.equals(other.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public void start(RequestControlContext context, MutableAttributeMap input) throws FlowExecutionException {
        MappingResults results;
        this.assertStartStateSet();
        this.createVariables(context);
        if (this.inputMapper != null && (results = this.inputMapper.map(input, context)) != null && results.hasErrorResults()) {
            throw new FlowInputMappingException(this.getId(), results);
        }
        this.startActionList.execute(context);
        this.startState.enter(context);
    }

    public void resume(RequestControlContext context) throws FlowExecutionException {
        this.restoreVariables(context);
        this.getCurrentViewState(context).resume(context);
    }

    public boolean handleEvent(RequestControlContext context) {
        TransitionableState currentState = this.getCurrentTransitionableState(context);
        try {
            return currentState.handleEvent(context);
        }
        catch (NoMatchingTransitionException e) {
            Transition transition = this.globalTransitionSet.getTransition(context);
            if (transition != null) {
                return context.execute(transition);
            }
            throw e;
        }
    }

    public void end(RequestControlContext context, String outcome, MutableAttributeMap output) throws FlowExecutionException {
        MappingResults results;
        this.endActionList.execute(context);
        if (this.outputMapper != null && (results = this.outputMapper.map(context, output)) != null && results.hasErrorResults()) {
            throw new FlowOutputMappingException(this.getId(), results);
        }
    }

    public void destroy() {
        if (this.applicationContext != null && this.applicationContext instanceof ConfigurableApplicationContext) {
            ((ConfigurableApplicationContext)this.applicationContext).close();
        }
    }

    public boolean handleException(FlowExecutionException exception, RequestControlContext context) throws FlowExecutionException {
        return this.getExceptionHandlerSet().handleException(exception, context);
    }

    private void assertStartStateSet() {
        if (this.startState == null) {
            throw new IllegalStateException("Unable to start flow '" + this.id + "'; the start state is not set -- flow builder configuration error?");
        }
    }

    private void createVariables(RequestContext context) {
        for (FlowVariable variable : this.variables.values()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Creating " + variable);
            }
            variable.create(context);
        }
    }

    public void restoreVariables(RequestContext context) {
        for (FlowVariable variable : this.variables.values()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Restoring " + variable);
            }
            variable.restore(context);
        }
    }

    private ViewState getCurrentViewState(RequestControlContext context) {
        State currentState = (State)context.getCurrentState();
        if (!(currentState instanceof ViewState)) {
            throw new IllegalStateException("You can only resume paused view states, and state " + context.getCurrentState() + " is not a view state - programmer error");
        }
        return (ViewState)currentState;
    }

    private TransitionableState getCurrentTransitionableState(RequestControlContext context) {
        State currentState = (State)context.getCurrentState();
        if (!(currentState instanceof TransitionableState)) {
            throw new IllegalStateException("You can only signal events in transitionable states, and state " + context.getCurrentState() + " is not transitionable - programmer error");
        }
        return (TransitionableState)currentState;
    }

    public String toString() {
        return new ToStringCreator(this).append("id", this.id).append("states", this.states).append("startState", this.startState).append("variables", this.variables).append("inputMapper", this.inputMapper).append("startActionList", this.startActionList).append("exceptionHandlerSet", this.exceptionHandlerSet).append("globalTransitionSet", this.globalTransitionSet).append("endActionList", this.endActionList).append("outputMapper", this.outputMapper).toString();
    }
}

