/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.bind.support;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.Part;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.util.ClassUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindException;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.multipart.MultipartException;
import org.springframework.web.multipart.MultipartRequest;

public class WebRequestDataBinder
extends WebDataBinder {
    public WebRequestDataBinder(Object target) {
        super(target);
    }

    public WebRequestDataBinder(Object target, String objectName) {
        super(target, objectName);
    }

    public void bind(WebRequest request) {
        MutablePropertyValues mpvs = new MutablePropertyValues(request.getParameterMap());
        if (this.isMultipartRequest(request) && request instanceof NativeWebRequest) {
            MultipartRequest multipartRequest = ((NativeWebRequest)request).getNativeRequest(MultipartRequest.class);
            if (multipartRequest != null) {
                this.bindMultipart(multipartRequest.getMultiFileMap(), mpvs);
            } else if (ClassUtils.hasMethod(HttpServletRequest.class, "getParts", new Class[0])) {
                HttpServletRequest serlvetRequest = ((NativeWebRequest)request).getNativeRequest(HttpServletRequest.class);
                new Servlet3MultipartHelper(this.isBindEmptyMultipartFiles()).bindParts(serlvetRequest, mpvs);
            }
        }
        this.doBind(mpvs);
    }

    public void closeNoCatch() throws BindException {
        if (this.getBindingResult().hasErrors()) {
            throw new BindException(this.getBindingResult());
        }
    }

    private boolean isMultipartRequest(WebRequest request) {
        String contentType = request.getHeader("Content-Type");
        return contentType != null && StringUtils.startsWithIgnoreCase(contentType, "multipart");
    }

    private static class Servlet3MultipartHelper {
        private final boolean bindEmptyMultipartFiles;

        public Servlet3MultipartHelper(boolean bindEmptyMultipartFiles) {
            this.bindEmptyMultipartFiles = bindEmptyMultipartFiles;
        }

        public void bindParts(HttpServletRequest request, MutablePropertyValues mpvs) {
            try {
                LinkedMultiValueMap<String, Part> map = new LinkedMultiValueMap<String, Part>();
                for (Part part : request.getParts()) {
                    map.add(part.getName(), part);
                }
                for (Map.Entry entry : map.entrySet()) {
                    if (((List)entry.getValue()).size() == 1) {
                        Part part = (Part)((List)entry.getValue()).get(0);
                        if (!this.bindEmptyMultipartFiles && part.getSize() <= 0L) continue;
                        mpvs.add((String)entry.getKey(), part);
                        continue;
                    }
                    mpvs.add((String)entry.getKey(), entry.getValue());
                }
            }
            catch (IOException ex) {
                throw new MultipartException("Failed to get request parts", ex);
            }
            catch (ServletException ex) {
                throw new MultipartException("Failed to get request parts", ex);
            }
        }
    }
}

