/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.js.ajax.tiles2;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.tiles.Attribute;
import org.apache.tiles.AttributeContext;
import org.apache.tiles.Definition;
import org.apache.tiles.context.TilesRequestContext;
import org.apache.tiles.context.TilesRequestContextFactory;
import org.apache.tiles.impl.BasicTilesContainer;
import org.apache.tiles.servlet.context.ServletTilesRequestContextFactory;
import org.apache.tiles.servlet.context.ServletUtil;
import org.springframework.js.ajax.AjaxHandler;
import org.springframework.js.ajax.SpringJavascriptAjaxHandler;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.support.JstlUtils;
import org.springframework.web.servlet.support.RequestContext;
import org.springframework.web.servlet.view.tiles2.TilesView;

public class AjaxTilesView
extends TilesView {
    private static final String FRAGMENTS_PARAM = "fragments";
    private TilesRequestContextFactory tilesRequestContextFactory;
    private AjaxHandler ajaxHandler = new SpringJavascriptAjaxHandler();

    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        this.tilesRequestContextFactory = new ServletTilesRequestContextFactory();
        this.tilesRequestContextFactory.init(new HashMap());
    }

    public AjaxHandler getAjaxHandler() {
        return this.ajaxHandler;
    }

    public void setAjaxHandler(AjaxHandler ajaxHandler) {
        this.ajaxHandler = ajaxHandler;
    }

    protected void renderMergedOutputModel(Map model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ServletContext servletContext = this.getServletContext();
        if (this.ajaxHandler.isAjaxRequest(request, response)) {
            String[] fragmentsToRender = this.getRenderFragments(model, request, response);
            if (fragmentsToRender.length == 0) {
                this.logger.warn("An Ajax request was detected, but no fragments were specified to be re-rendered.  Falling back to full page render.  This can cause unpredictable results when processing the ajax response on the client.");
                super.renderMergedOutputModel(model, request, response);
                return;
            }
            BasicTilesContainer container = (BasicTilesContainer)ServletUtil.getCurrentContainer((ServletRequest)request, (ServletContext)servletContext);
            if (container == null) {
                throw new ServletException("Tiles container is not initialized. Have you added a TilesConfigurer to your web application context?");
            }
            this.exposeModelAsRequestAttributes(model, request);
            JstlUtils.exposeLocalizationContext(new RequestContext(request, servletContext));
            TilesRequestContext tilesRequestContext = this.tilesRequestContextFactory.createRequestContext(container.getApplicationContext(), new Object[]{request, response});
            Definition compositeDefinition = container.getDefinitionsFactory().getDefinition(this.getUrl(), tilesRequestContext);
            HashMap flattenedAttributeMap = new HashMap();
            this.flattenAttributeMap(container, tilesRequestContext, flattenedAttributeMap, compositeDefinition, request, response);
            this.addRuntimeAttributes(container, flattenedAttributeMap, request, response);
            if (fragmentsToRender.length > 1) {
                request.setAttribute("org.apache.tiles.servlet.context.ServletTilesRequestContext.FORCE_INCLUDE", (Object)true);
            }
            for (int i = 0; i < fragmentsToRender.length; ++i) {
                Attribute attributeToRender = (Attribute)flattenedAttributeMap.get(fragmentsToRender[i]);
                if (attributeToRender == null) {
                    throw new ServletException("No tiles attribute with a name of '" + fragmentsToRender[i] + "' could be found for the current view: " + this);
                }
                container.startContext(new Object[]{request, response}).inheritCascadedAttributes((AttributeContext)compositeDefinition);
                container.render(attributeToRender, new Object[]{request, response});
                container.endContext(new Object[]{request, response});
            }
        } else {
            super.renderMergedOutputModel(model, request, response);
        }
    }

    protected String[] getRenderFragments(Map model, HttpServletRequest request, HttpServletResponse response) {
        String attrName = request.getParameter(FRAGMENTS_PARAM);
        String[] renderFragments = StringUtils.commaDelimitedListToStringArray(attrName);
        return StringUtils.trimArrayElements(renderFragments);
    }

    protected void flattenAttributeMap(BasicTilesContainer container, TilesRequestContext requestContext, Map resultMap, Definition compositeDefinition, HttpServletRequest request, HttpServletResponse response) {
        Iterator iterator = compositeDefinition.getAttributeNames();
        while (iterator.hasNext()) {
            String attributeName = (String)iterator.next();
            Attribute attribute = compositeDefinition.getAttribute(attributeName);
            if (attribute.getValue() == null || !(attribute.getValue() instanceof String)) continue;
            String value = attribute.getValue().toString();
            if (value.startsWith("/")) {
                resultMap.put(attributeName, attribute);
                continue;
            }
            if (!container.isValidDefinition(value, new Object[]{request, response})) continue;
            resultMap.put(attributeName, attribute);
            Definition nestedDefinition = container.getDefinitionsFactory().getDefinition(value, requestContext);
            Assert.isTrue(nestedDefinition != compositeDefinition, "Circular nested definition: " + value);
            this.flattenAttributeMap(container, requestContext, resultMap, nestedDefinition, request, response);
        }
    }

    protected void addRuntimeAttributes(BasicTilesContainer container, Map resultMap, HttpServletRequest request, HttpServletResponse response) {
        AttributeContext attributeContext = container.getAttributeContext(new Object[]{request, response});
        HashSet attributeNames = new HashSet();
        if (attributeContext.getLocalAttributeNames() != null) {
            attributeNames.addAll(attributeContext.getLocalAttributeNames());
        }
        if (attributeContext.getCascadedAttributeNames() != null) {
            attributeNames.addAll(attributeContext.getCascadedAttributeNames());
        }
        for (String name : attributeNames) {
            Attribute attr = attributeContext.getAttribute(name);
            resultMap.put(name, attr);
        }
    }
}

