/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.validation;

import java.lang.reflect.Method;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.binding.expression.ExpressionParser;
import org.springframework.binding.mapping.MappingResults;
import org.springframework.binding.message.MessageContext;
import org.springframework.binding.message.MessageContextErrors;
import org.springframework.binding.validation.ValidationContext;
import org.springframework.context.ApplicationContext;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.validation.Errors;
import org.springframework.validation.MessageCodesResolver;
import org.springframework.validation.Validator;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.validation.DefaultValidationContext;

public class ValidationHelper {
    private static final Log logger = LogFactory.getLog(ValidationHelper.class);
    private final Object model;
    private final RequestContext requestContext;
    private final String eventId;
    private final String modelName;
    private final ExpressionParser expressionParser;
    private final MessageCodesResolver messageCodesResolver;
    private final MappingResults mappingResults;
    private Validator validator;

    public ValidationHelper(Object model, RequestContext requestContext, String eventId, String modelName, ExpressionParser expressionParser, MessageCodesResolver messageCodesResolver, MappingResults mappingResults) {
        Assert.notNull(model, "The model to validate is required");
        Assert.notNull(requestContext, "The request context for the validator is required");
        this.model = model;
        this.requestContext = requestContext;
        this.eventId = eventId;
        this.modelName = modelName;
        this.expressionParser = expressionParser;
        this.messageCodesResolver = messageCodesResolver;
        this.mappingResults = mappingResults;
    }

    public void setValidator(Validator validator) {
        this.validator = validator;
    }

    public void validate() {
        if (this.validator != null) {
            this.invokeValidatorDefaultValidateMethod(this.model, this.validator);
        }
        this.invokeModelValidationMethod(this.model);
        Object modelValidator = this.getModelValidator();
        if (modelValidator != null) {
            this.invokeModelValidator(this.model, modelValidator);
        }
    }

    private void invokeModelValidationMethod(Object model) {
        this.invokeValidateMethodForCurrentState(model);
        this.invokeDefaultValidateMethod(model);
    }

    private boolean invokeValidateMethodForCurrentState(Object model) {
        String methodName = "validate" + StringUtils.capitalize(this.requestContext.getCurrentState().getId());
        Method validateMethod = ReflectionUtils.findMethod(model.getClass(), methodName, ValidationContext.class);
        if (validateMethod != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Invoking current state model validation method '" + methodName + "(ValidationContext)'");
            }
            ReflectionUtils.invokeMethod(validateMethod, model, new DefaultValidationContext(this.requestContext, this.eventId, this.mappingResults));
            return true;
        }
        validateMethod = ReflectionUtils.findMethod(model.getClass(), methodName, MessageContext.class);
        if (validateMethod != null) {
            ReflectionUtils.invokeMethod(validateMethod, model, this.requestContext.getMessageContext());
            return true;
        }
        validateMethod = ReflectionUtils.findMethod(model.getClass(), methodName, Errors.class);
        if (validateMethod != null) {
            MessageContextErrors errors = new MessageContextErrors(this.requestContext.getMessageContext(), this.modelName, model, this.expressionParser, this.messageCodesResolver, this.mappingResults);
            if (logger.isDebugEnabled()) {
                logger.debug("Invoking current state model validation method '" + methodName + "(Errors)'");
            }
            ReflectionUtils.invokeMethod(validateMethod, model, errors);
            return true;
        }
        return false;
    }

    private boolean invokeDefaultValidateMethod(Object model) {
        Method validateMethod = ReflectionUtils.findMethod(model.getClass(), "validate", ValidationContext.class);
        if (validateMethod != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Invoking default model validation method 'validate(ValidationContext)'");
            }
            ReflectionUtils.invokeMethod(validateMethod, model, new DefaultValidationContext(this.requestContext, this.eventId, this.mappingResults));
            return true;
        }
        validateMethod = ReflectionUtils.findMethod(model.getClass(), "validate", Errors.class);
        if (validateMethod != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Invoking default model validation method 'validate(Errors)'");
            }
            MessageContextErrors errors = new MessageContextErrors(this.requestContext.getMessageContext(), this.modelName, model, this.expressionParser, this.messageCodesResolver, this.mappingResults);
            ReflectionUtils.invokeMethod(validateMethod, model, errors);
            return true;
        }
        return false;
    }

    private Object getModelValidator() {
        String validatorName;
        ApplicationContext beanFactory = this.requestContext.getActiveFlow().getApplicationContext();
        if (beanFactory != null && StringUtils.hasText(this.modelName) && beanFactory.containsBean(validatorName = String.valueOf(this.modelName) + "Validator")) {
            return beanFactory.getBean(validatorName);
        }
        return null;
    }

    private void invokeModelValidator(Object model, Object validator) {
        this.invokeValidatorValidateMethodForCurrentState(model, validator);
        this.invokeValidatorDefaultValidateMethod(model, validator);
    }

    private boolean invokeValidatorValidateMethodForCurrentState(Object model, Object validator) {
        String methodName = "validate" + StringUtils.capitalize(this.requestContext.getCurrentState().getId());
        Method validateMethod = this.findValidationMethod(model, validator, methodName, ValidationContext.class);
        if (validateMethod != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Invoking current state validator method '" + ClassUtils.getShortName(validator.getClass()) + "." + methodName + "(" + ClassUtils.getShortName(model.getClass()) + ", ValidationContext)'");
            }
            ReflectionUtils.invokeMethod(validateMethod, validator, model, new DefaultValidationContext(this.requestContext, this.eventId, this.mappingResults));
            return true;
        }
        validateMethod = this.findValidationMethod(model, validator, methodName, Errors.class);
        if (validateMethod != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Invoking current state validator method '" + ClassUtils.getShortName(validator.getClass()) + "." + methodName + "(" + ClassUtils.getShortName(model.getClass()) + ", Errors)'");
            }
            MessageContextErrors errors = new MessageContextErrors(this.requestContext.getMessageContext(), this.modelName, model, this.expressionParser, this.messageCodesResolver, this.mappingResults);
            ReflectionUtils.invokeMethod(validateMethod, validator, model, errors);
            return true;
        }
        validateMethod = this.findValidationMethod(model, validator, methodName, MessageContext.class);
        if (validateMethod != null) {
            ReflectionUtils.invokeMethod(validateMethod, validator, model, this.requestContext.getMessageContext());
            return true;
        }
        return false;
    }

    private boolean invokeValidatorDefaultValidateMethod(Object model, Object validator) {
        if (validator instanceof Validator) {
            Validator springValidator = (Validator)validator;
            if (logger.isDebugEnabled()) {
                logger.debug("Invoking Spring Validator '" + ClassUtils.getShortName(validator.getClass()) + "'");
            }
            if (springValidator.supports(model.getClass())) {
                MessageContextErrors errors = new MessageContextErrors(this.requestContext.getMessageContext(), this.modelName, model, this.expressionParser, this.messageCodesResolver, this.mappingResults);
                springValidator.validate(model, errors);
            } else if (logger.isDebugEnabled()) {
                logger.debug("Spring Validator '" + ClassUtils.getShortName(validator.getClass()) + "' doesn't support model class " + model.getClass());
            }
            return true;
        }
        Method validateMethod = this.findValidationMethod(model, validator, "validate", ValidationContext.class);
        if (validateMethod != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Invoking default validator method '" + ClassUtils.getShortName(validator.getClass()) + ".validate(" + ClassUtils.getShortName(model.getClass()) + ", ValidationContext)'");
            }
            ReflectionUtils.invokeMethod(validateMethod, validator, model, new DefaultValidationContext(this.requestContext, this.eventId, this.mappingResults));
            return true;
        }
        validateMethod = this.findValidationMethod(model, validator, "validate", Errors.class);
        if (validateMethod != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Invoking default validator method '" + ClassUtils.getShortName(validator.getClass()) + ".validate(" + ClassUtils.getShortName(model.getClass()) + ", Errors)'");
            }
            MessageContextErrors errors = new MessageContextErrors(this.requestContext.getMessageContext(), this.modelName, model, this.expressionParser, this.messageCodesResolver, this.mappingResults);
            ReflectionUtils.invokeMethod(validateMethod, validator, model, errors);
            return true;
        }
        return false;
    }

    private Method findValidationMethod(Object model, Object validator, String methodName, Class context) {
        Class<?> modelClass = AopUtils.getTargetClass(model);
        ArrayList modelSearchClasses = new ArrayList();
        while (modelClass != null) {
            modelSearchClasses.add(modelClass);
            modelClass = modelClass.getSuperclass();
        }
        for (Class clazz : modelSearchClasses) {
            Method method = ReflectionUtils.findMethod(validator.getClass(), methodName, clazz, context);
            if (method == null) continue;
            return method;
        }
        return null;
    }
}

