/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.execution.factory;

import org.springframework.core.style.StylerUtils;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.webflow.definition.FlowDefinition;
import org.springframework.webflow.execution.factory.FlowExecutionListenerCriteria;

public class FlowExecutionListenerCriteriaFactory {
    private static final WildcardFlowExecutionListenerCriteria WILDCARD_INSTANCE = new WildcardFlowExecutionListenerCriteria();

    public FlowExecutionListenerCriteria getListenerCriteria(String encodedCriteria) {
        if ("*".equals(encodedCriteria)) {
            return this.allFlows();
        }
        String[] flowIds = StringUtils.commaDelimitedListToStringArray(encodedCriteria);
        int i = 0;
        while (i < flowIds.length) {
            flowIds[i] = flowIds[i].trim();
            ++i;
        }
        return this.flows(flowIds);
    }

    public FlowExecutionListenerCriteria allFlows() {
        return WILDCARD_INSTANCE;
    }

    public FlowExecutionListenerCriteria flow(String flowId) {
        return new FlowIdFlowExecutionListenerCriteria(new String[]{flowId});
    }

    public FlowExecutionListenerCriteria flows(String[] flowIds) {
        return new FlowIdFlowExecutionListenerCriteria(flowIds);
    }

    private static class FlowIdFlowExecutionListenerCriteria
    implements FlowExecutionListenerCriteria {
        private String[] flowIds;

        public FlowIdFlowExecutionListenerCriteria(String[] flowIds) {
            Assert.notEmpty(flowIds, "The flow id array is required");
            this.flowIds = flowIds;
        }

        public boolean appliesTo(FlowDefinition definition) {
            int i = 0;
            while (i < this.flowIds.length) {
                if (this.flowIds[i].equals(definition.getId())) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public String toString() {
            return new ToStringCreator(this).append("flowIds", StylerUtils.style(this.flowIds)).toString();
        }
    }

    private static class WildcardFlowExecutionListenerCriteria
    implements FlowExecutionListenerCriteria {
        private WildcardFlowExecutionListenerCriteria() {
        }

        public boolean appliesTo(FlowDefinition definition) {
            return true;
        }

        public String toString() {
            return "*";
        }
    }
}

