/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.execution;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.webflow.execution.Action;
import org.springframework.webflow.execution.ActionExecutionException;
import org.springframework.webflow.execution.AnnotatedAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class ActionExecutor {
    private static final Log logger = LogFactory.getLog(ActionExecutor.class);

    private ActionExecutor() {
    }

    public static Event execute(Action action, RequestContext context) throws ActionExecutionException {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Executing " + ActionExecutor.getTargetAction(action));
            }
            Event event = action.execute(context);
            if (logger.isDebugEnabled()) {
                logger.debug("Finished executing " + ActionExecutor.getTargetAction(action) + "; result = " + event);
            }
            return event;
        }
        catch (ActionExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ActionExecutionException(context.getActiveFlow().getId(), context.getCurrentState() != null ? context.getCurrentState().getId() : null, action, context.getAttributes(), e);
        }
    }

    private static Action getTargetAction(Action action) {
        if (action instanceof AnnotatedAction) {
            return ActionExecutor.getTargetAction(((AnnotatedAction)action).getTargetAction());
        }
        return action;
    }
}

