/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine.model.builder.xml;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.springframework.core.io.Resource;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.springframework.webflow.engine.model.AbstractActionModel;
import org.springframework.webflow.engine.model.AbstractStateModel;
import org.springframework.webflow.engine.model.ActionStateModel;
import org.springframework.webflow.engine.model.AttributeModel;
import org.springframework.webflow.engine.model.BeanImportModel;
import org.springframework.webflow.engine.model.BinderModel;
import org.springframework.webflow.engine.model.BindingModel;
import org.springframework.webflow.engine.model.DecisionStateModel;
import org.springframework.webflow.engine.model.EndStateModel;
import org.springframework.webflow.engine.model.EvaluateModel;
import org.springframework.webflow.engine.model.ExceptionHandlerModel;
import org.springframework.webflow.engine.model.FlowModel;
import org.springframework.webflow.engine.model.IfModel;
import org.springframework.webflow.engine.model.InputModel;
import org.springframework.webflow.engine.model.OutputModel;
import org.springframework.webflow.engine.model.PersistenceContextModel;
import org.springframework.webflow.engine.model.RenderModel;
import org.springframework.webflow.engine.model.SecuredModel;
import org.springframework.webflow.engine.model.SetModel;
import org.springframework.webflow.engine.model.SubflowStateModel;
import org.springframework.webflow.engine.model.TransitionModel;
import org.springframework.webflow.engine.model.VarModel;
import org.springframework.webflow.engine.model.ViewStateModel;
import org.springframework.webflow.engine.model.builder.FlowModelBuilder;
import org.springframework.webflow.engine.model.builder.FlowModelBuilderException;
import org.springframework.webflow.engine.model.builder.xml.DefaultDocumentLoader;
import org.springframework.webflow.engine.model.builder.xml.DocumentLoader;
import org.springframework.webflow.engine.model.registry.FlowModelLocator;
import org.springframework.webflow.engine.model.registry.NoSuchFlowModelException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class XmlFlowModelBuilder
implements FlowModelBuilder {
    private Resource resource;
    private FlowModelLocator modelLocator;
    private DocumentLoader documentLoader = new DefaultDocumentLoader();
    private Document document;
    private long lastModifiedTimestamp;
    private FlowModel flowModel;

    public XmlFlowModelBuilder(Resource resource) {
        this.init(resource, null);
    }

    public XmlFlowModelBuilder(Resource resource, FlowModelLocator modelLocator) {
        this.init(resource, modelLocator);
    }

    public void setDocumentLoader(DocumentLoader documentLoader) {
        Assert.notNull(documentLoader, "The XML document loader is required");
        this.documentLoader = documentLoader;
    }

    public void init() throws FlowModelBuilderException {
        try {
            this.document = this.documentLoader.loadDocument(this.resource);
            this.initLastModifiedTimestamp();
        }
        catch (IOException e) {
            throw new FlowModelBuilderException("Could not access the XML flow definition at " + this.resource, e);
        }
        catch (ParserConfigurationException e) {
            throw new FlowModelBuilderException("Could not configure the parser to parse the XML flow definition at " + this.resource, e);
        }
        catch (SAXException e) {
            throw new FlowModelBuilderException("Could not parse the XML flow definition document at " + this.resource, e);
        }
    }

    public void build() throws FlowModelBuilderException {
        if (this.getDocumentElement() == null) {
            throw new FlowModelBuilderException("The FlowModelBuilder must be initialized first -- called init() before calling build()");
        }
        this.flowModel = this.parseFlow(this.getDocumentElement());
        this.mergeFlows();
        this.mergeStates();
    }

    public FlowModel getFlowModel() throws FlowModelBuilderException {
        if (this.flowModel == null) {
            throw new FlowModelBuilderException("The FlowModel must be built first -- called init() and build() before calling getFlowModel()");
        }
        return this.flowModel;
    }

    public void dispose() throws FlowModelBuilderException {
        this.document = null;
        this.flowModel = null;
    }

    public Resource getFlowModelResource() {
        return this.resource;
    }

    public boolean hasFlowModelResourceChanged() {
        if (this.lastModifiedTimestamp == -1L) {
            return false;
        }
        try {
            long lastModified = this.resource.lastModified();
            return lastModified > this.lastModifiedTimestamp;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    protected Document getDocument() {
        return this.document;
    }

    protected Element getDocumentElement() {
        return this.document != null ? this.document.getDocumentElement() : null;
    }

    private void init(Resource resource, FlowModelLocator modelLocator) {
        Assert.notNull(resource, "The location of the XML-based flow definition is required");
        this.resource = resource;
        this.modelLocator = modelLocator;
    }

    private void initLastModifiedTimestamp() {
        try {
            this.lastModifiedTimestamp = this.resource.lastModified();
        }
        catch (IOException iOException) {
            this.lastModifiedTimestamp = -1L;
        }
    }

    private FlowModel parseFlow(Element element) {
        FlowModel flow = new FlowModel();
        flow.setAbstract(element.getAttribute("abstract"));
        flow.setParent(element.getAttribute("parent"));
        flow.setStartStateId(element.getAttribute("start-state"));
        flow.setAttributes(this.parseAttributes(element));
        flow.setSecured(this.parseSecured(element));
        flow.setPersistenceContext(this.parsePersistenceContext(element));
        flow.setVars(this.parseVars(element));
        flow.setInputs(this.parseInputs(element));
        flow.setOnStartActions(this.parseOnStartActions(element));
        flow.setStates(this.parseStates(element));
        flow.setGlobalTransitions(this.parseGlobalTransitions(element));
        flow.setOnEndActions(this.parseOnEndActions(element));
        flow.setOutputs(this.parseOutputs(element));
        flow.setExceptionHandlers(this.parseExceptionHandlers(element));
        flow.setBeanImports(this.parseBeanImports(element));
        return flow;
    }

    private LinkedList parseAttributes(Element element) {
        List<Element> attributeElements = DomUtils.getChildElementsByTagName(element, "attribute");
        if (attributeElements.isEmpty()) {
            return null;
        }
        LinkedList<AttributeModel> attributes = new LinkedList<AttributeModel>();
        Iterator<Element> it = attributeElements.iterator();
        while (it.hasNext()) {
            attributes.add(this.parseAttribute(it.next()));
        }
        return attributes;
    }

    private LinkedList parseVars(Element element) {
        List<Element> varElements = DomUtils.getChildElementsByTagName(element, "var");
        if (varElements.isEmpty()) {
            return null;
        }
        LinkedList<VarModel> vars = new LinkedList<VarModel>();
        Iterator<Element> it = varElements.iterator();
        while (it.hasNext()) {
            vars.add(this.parseVar(it.next()));
        }
        return vars;
    }

    private LinkedList parseInputs(Element element) {
        List<Element> inputElements = DomUtils.getChildElementsByTagName(element, "input");
        if (inputElements.isEmpty()) {
            return null;
        }
        LinkedList<InputModel> inputs = new LinkedList<InputModel>();
        Iterator<Element> it = inputElements.iterator();
        while (it.hasNext()) {
            inputs.add(this.parseInput(it.next()));
        }
        return inputs;
    }

    private LinkedList parseOutputs(Element element) {
        List<Element> outputElements = DomUtils.getChildElementsByTagName(element, "output");
        if (outputElements.isEmpty()) {
            return null;
        }
        LinkedList<OutputModel> outputs = new LinkedList<OutputModel>();
        Iterator<Element> it = outputElements.iterator();
        while (it.hasNext()) {
            outputs.add(this.parseOutput(it.next()));
        }
        return outputs;
    }

    private LinkedList parseActions(Element element) {
        List<Element> actionElements = DomUtils.getChildElementsByTagName(element, "evaluate", "render", "set");
        if (actionElements.isEmpty()) {
            return null;
        }
        LinkedList<AbstractActionModel> actions2 = new LinkedList<AbstractActionModel>();
        Iterator<Element> it = actionElements.iterator();
        while (it.hasNext()) {
            actions2.add(this.parseAction(it.next()));
        }
        return actions2;
    }

    private LinkedList parseStates(Element element) {
        List<Element> stateElements = DomUtils.getChildElementsByTagName(element, "view-state", "action-state", "decision-state", "subflow-state", "end-state");
        if (stateElements.isEmpty()) {
            return null;
        }
        LinkedList<AbstractStateModel> states = new LinkedList<AbstractStateModel>();
        Iterator<Element> it = stateElements.iterator();
        while (it.hasNext()) {
            states.add(this.parseState(it.next()));
        }
        return states;
    }

    private LinkedList parseTransitions(Element element) {
        List<Element> transitionElements = DomUtils.getChildElementsByTagName(element, "transition");
        if (transitionElements.isEmpty()) {
            return null;
        }
        LinkedList<TransitionModel> transitions = new LinkedList<TransitionModel>();
        Iterator<Element> it = transitionElements.iterator();
        while (it.hasNext()) {
            transitions.add(this.parseTransition(it.next()));
        }
        return transitions;
    }

    private LinkedList parseExceptionHandlers(Element element) {
        List<Element> exceptionHandlerElements = DomUtils.getChildElementsByTagName(element, "exception-handler");
        if (exceptionHandlerElements.isEmpty()) {
            return null;
        }
        LinkedList<ExceptionHandlerModel> exceptionHandlers = new LinkedList<ExceptionHandlerModel>();
        Iterator<Element> it = exceptionHandlerElements.iterator();
        while (it.hasNext()) {
            exceptionHandlers.add(this.parseExceptionHandler(it.next()));
        }
        return exceptionHandlers;
    }

    private LinkedList parseBeanImports(Element element) {
        List<Element> importElements = DomUtils.getChildElementsByTagName(element, "bean-import");
        if (importElements.isEmpty()) {
            return null;
        }
        LinkedList<BeanImportModel> beanImports = new LinkedList<BeanImportModel>();
        Iterator<Element> it = importElements.iterator();
        while (it.hasNext()) {
            beanImports.add(this.parseBeanImport(it.next()));
        }
        return beanImports;
    }

    private LinkedList parseIfs(Element element) {
        List<Element> ifElements = DomUtils.getChildElementsByTagName(element, "if");
        if (ifElements.isEmpty()) {
            return null;
        }
        LinkedList<IfModel> ifs = new LinkedList<IfModel>();
        Iterator<Element> it = ifElements.iterator();
        while (it.hasNext()) {
            ifs.add(this.parseIf(it.next()));
        }
        return ifs;
    }

    private AbstractActionModel parseAction(Element element) {
        if (DomUtils.nodeNameEquals(element, "evaluate")) {
            return this.parseEvaluate(element);
        }
        if (DomUtils.nodeNameEquals(element, "render")) {
            return this.parseRender(element);
        }
        if (DomUtils.nodeNameEquals(element, "set")) {
            return this.parseSet(element);
        }
        throw new FlowModelBuilderException("Unknown action element encountered '" + element.getLocalName() + "'");
    }

    private AbstractStateModel parseState(Element element) {
        if (DomUtils.nodeNameEquals(element, "view-state")) {
            return this.parseViewState(element);
        }
        if (DomUtils.nodeNameEquals(element, "action-state")) {
            return this.parseActionState(element);
        }
        if (DomUtils.nodeNameEquals(element, "decision-state")) {
            return this.parseDecisionState(element);
        }
        if (DomUtils.nodeNameEquals(element, "subflow-state")) {
            return this.parseSubflowState(element);
        }
        if (DomUtils.nodeNameEquals(element, "end-state")) {
            return this.parseEndState(element);
        }
        throw new FlowModelBuilderException("Unknown state element encountered '" + element.getLocalName() + "'");
    }

    private LinkedList parseGlobalTransitions(Element element) {
        if ((element = DomUtils.getChildElementByTagName(element, "global-transitions")) == null) {
            return null;
        }
        return this.parseTransitions(element);
    }

    private AttributeModel parseAttribute(Element element) {
        AttributeModel attribute = new AttributeModel(element.getAttribute("name"), this.parseAttributeValue(element));
        attribute.setType(element.getAttribute("type"));
        return attribute;
    }

    private String parseAttributeValue(Element element) {
        if (element.hasAttribute("value")) {
            return element.getAttribute("value");
        }
        Element valueElement = DomUtils.getChildElementByTagName(element, "value");
        if (valueElement != null) {
            return DomUtils.getTextValue(valueElement);
        }
        return null;
    }

    private SecuredModel parseSecured(Element element) {
        if ((element = DomUtils.getChildElementByTagName(element, "secured")) == null) {
            return null;
        }
        SecuredModel secured = new SecuredModel(element.getAttribute("attributes"));
        secured.setMatch(element.getAttribute("match"));
        return secured;
    }

    private PersistenceContextModel parsePersistenceContext(Element element) {
        if ((element = DomUtils.getChildElementByTagName(element, "persistence-context")) == null) {
            return null;
        }
        return new PersistenceContextModel();
    }

    private VarModel parseVar(Element element) {
        return new VarModel(element.getAttribute("name"), element.getAttribute("class"));
    }

    private InputModel parseInput(Element element) {
        InputModel input = new InputModel(element.getAttribute("name"), element.getAttribute("value"));
        input.setType(element.getAttribute("type"));
        input.setRequired(element.getAttribute("required"));
        return input;
    }

    private OutputModel parseOutput(Element element) {
        OutputModel output = new OutputModel(element.getAttribute("name"), element.getAttribute("value"));
        output.setType(element.getAttribute("type"));
        output.setRequired(element.getAttribute("required"));
        return output;
    }

    private TransitionModel parseTransition(Element element) {
        TransitionModel transition = new TransitionModel();
        transition.setOn(element.getAttribute("on"));
        transition.setTo(element.getAttribute("to"));
        transition.setOnException(element.getAttribute("on-exception"));
        transition.setBind(element.getAttribute("bind"));
        transition.setValidate(element.getAttribute("validate"));
        transition.setHistory(element.getAttribute("history"));
        transition.setAttributes(this.parseAttributes(element));
        transition.setSecured(this.parseSecured(element));
        transition.setActions(this.parseActions(element));
        return transition;
    }

    private ExceptionHandlerModel parseExceptionHandler(Element element) {
        return new ExceptionHandlerModel(element.getAttribute("bean"));
    }

    private BeanImportModel parseBeanImport(Element element) {
        return new BeanImportModel(element.getAttribute("resource"));
    }

    private IfModel parseIf(Element element) {
        IfModel ifModel = new IfModel(element.getAttribute("test"), element.getAttribute("then"));
        ifModel.setElse(element.getAttribute("else"));
        return ifModel;
    }

    private LinkedList parseOnStartActions(Element element) {
        Element onStartElement = DomUtils.getChildElementByTagName(element, "on-start");
        if (onStartElement != null) {
            return this.parseActions(onStartElement);
        }
        return null;
    }

    private LinkedList parseOnEntryActions(Element element) {
        Element onEntryElement = DomUtils.getChildElementByTagName(element, "on-entry");
        if (onEntryElement != null) {
            return this.parseActions(onEntryElement);
        }
        return null;
    }

    private LinkedList parseOnRenderActions(Element element) {
        Element onRenderElement = DomUtils.getChildElementByTagName(element, "on-render");
        if (onRenderElement != null) {
            return this.parseActions(onRenderElement);
        }
        return null;
    }

    private BinderModel parseBinder(Element element) {
        Element binderElement = DomUtils.getChildElementByTagName(element, "binder");
        if (binderElement != null) {
            BinderModel binder = new BinderModel();
            binder.setBindings(this.parseBindings(binderElement));
            return binder;
        }
        return null;
    }

    private LinkedList parseBindings(Element element) {
        List<Element> bindingElements = DomUtils.getChildElementsByTagName(element, "binding");
        if (bindingElements.isEmpty()) {
            return null;
        }
        LinkedList<BindingModel> bindings = new LinkedList<BindingModel>();
        Iterator<Element> it = bindingElements.iterator();
        while (it.hasNext()) {
            bindings.add(this.parseBinding(it.next()));
        }
        return bindings;
    }

    private BindingModel parseBinding(Element element) {
        return new BindingModel(element.getAttribute("property"), element.getAttribute("converter"), element.getAttribute("required"));
    }

    private LinkedList parseOnExitActions(Element element) {
        Element onExitElement = DomUtils.getChildElementByTagName(element, "on-exit");
        if (onExitElement != null) {
            return this.parseActions(onExitElement);
        }
        return null;
    }

    private LinkedList parseOnEndActions(Element element) {
        Element onEndElement = DomUtils.getChildElementByTagName(element, "on-end");
        if (onEndElement != null) {
            return this.parseActions(onEndElement);
        }
        return null;
    }

    private EvaluateModel parseEvaluate(Element element) {
        EvaluateModel evaluate = new EvaluateModel(element.getAttribute("expression"));
        evaluate.setResult(element.getAttribute("result"));
        evaluate.setResultType(element.getAttribute("result-type"));
        evaluate.setAttributes(this.parseAttributes(element));
        return evaluate;
    }

    private RenderModel parseRender(Element element) {
        RenderModel render = new RenderModel(element.getAttribute("fragments"));
        render.setAttributes(this.parseAttributes(element));
        return render;
    }

    private SetModel parseSet(Element element) {
        SetModel set = new SetModel(element.getAttribute("name"), element.getAttribute("value"));
        set.setType(element.getAttribute("type"));
        set.setAttributes(this.parseAttributes(element));
        return set;
    }

    private ActionStateModel parseActionState(Element element) {
        ActionStateModel state = new ActionStateModel(element.getAttribute("id"));
        state.setParent(element.getAttribute("parent"));
        state.setAttributes(this.parseAttributes(element));
        state.setSecured(this.parseSecured(element));
        state.setOnEntryActions(this.parseOnEntryActions(element));
        state.setTransitions(this.parseTransitions(element));
        state.setOnExitActions(this.parseOnExitActions(element));
        state.setActions(this.parseActions(element));
        state.setExceptionHandlers(this.parseExceptionHandlers(element));
        return state;
    }

    private ViewStateModel parseViewState(Element element) {
        ViewStateModel state = new ViewStateModel(element.getAttribute("id"));
        state.setParent(element.getAttribute("parent"));
        state.setView(element.getAttribute("view"));
        state.setRedirect(element.getAttribute("redirect"));
        state.setPopup(element.getAttribute("popup"));
        state.setModel(element.getAttribute("model"));
        state.setVars(this.parseVars(element));
        state.setBinder(this.parseBinder(element));
        state.setOnRenderActions(this.parseOnRenderActions(element));
        state.setAttributes(this.parseAttributes(element));
        state.setSecured(this.parseSecured(element));
        state.setOnEntryActions(this.parseOnEntryActions(element));
        state.setExceptionHandlers(this.parseExceptionHandlers(element));
        state.setTransitions(this.parseTransitions(element));
        state.setOnExitActions(this.parseOnExitActions(element));
        return state;
    }

    private DecisionStateModel parseDecisionState(Element element) {
        DecisionStateModel state = new DecisionStateModel(element.getAttribute("id"));
        state.setParent(element.getAttribute("parent"));
        state.setIfs(this.parseIfs(element));
        state.setOnExitActions(this.parseOnExitActions(element));
        state.setAttributes(this.parseAttributes(element));
        state.setSecured(this.parseSecured(element));
        state.setOnEntryActions(this.parseOnEntryActions(element));
        state.setExceptionHandlers(this.parseExceptionHandlers(element));
        return state;
    }

    private SubflowStateModel parseSubflowState(Element element) {
        SubflowStateModel state = new SubflowStateModel(element.getAttribute("id"), element.getAttribute("subflow"));
        state.setParent(element.getAttribute("parent"));
        state.setSubflowAttributeMapper(element.getAttribute("subflow-attribute-mapper"));
        state.setInputs(this.parseInputs(element));
        state.setOutputs(this.parseOutputs(element));
        state.setAttributes(this.parseAttributes(element));
        state.setSecured(this.parseSecured(element));
        state.setOnEntryActions(this.parseOnEntryActions(element));
        state.setExceptionHandlers(this.parseExceptionHandlers(element));
        state.setTransitions(this.parseTransitions(element));
        state.setOnExitActions(this.parseOnExitActions(element));
        return state;
    }

    private EndStateModel parseEndState(Element element) {
        EndStateModel state = new EndStateModel(element.getAttribute("id"));
        state.setParent(element.getAttribute("parent"));
        state.setView(element.getAttribute("view"));
        state.setCommit(element.getAttribute("commit"));
        state.setOutputs(this.parseOutputs(element));
        state.setAttributes(this.parseAttributes(element));
        state.setSecured(this.parseSecured(element));
        state.setOnEntryActions(this.parseOnEntryActions(element));
        state.setExceptionHandlers(this.parseExceptionHandlers(element));
        return state;
    }

    private void mergeFlows() {
        if (this.flowModel.getParent() != null) {
            List<String> parents = Arrays.asList(StringUtils.trimArrayElements(this.flowModel.getParent().split(",")));
            for (String parentFlowId : parents) {
                if (!StringUtils.hasText(parentFlowId)) continue;
                try {
                    this.flowModel.merge(this.modelLocator.getFlowModel(parentFlowId));
                }
                catch (NoSuchFlowModelException e) {
                    throw new FlowModelBuilderException("Unable to find flow '" + parentFlowId + "' to inherit from", e);
                }
            }
        }
    }

    private void mergeStates() {
        if (this.flowModel.getStates() == null) {
            return;
        }
        for (AbstractStateModel childState : this.flowModel.getStates()) {
            String parent = childState.getParent();
            if (childState.getParent() == null) continue;
            AbstractStateModel parentState = null;
            int hashIndex = parent.indexOf("#");
            if (hashIndex == -1) {
                throw new FlowModelBuilderException("Invalid parent syntax '" + parent + "', should take form 'flowId#stateId'");
            }
            String flowId = parent.substring(0, hashIndex).trim();
            String stateId = parent.substring(hashIndex + 1).trim();
            try {
                parentState = StringUtils.hasText(flowId) ? this.modelLocator.getFlowModel(flowId).getStateById(stateId) : this.flowModel.getStateById(stateId);
                if (parentState == null) {
                    throw new FlowModelBuilderException("Unable to find state '" + stateId + "' in flow '" + flowId + "'");
                }
                childState.merge(parentState);
            }
            catch (NoSuchFlowModelException e) {
                throw new FlowModelBuilderException("Unable to find flow '" + flowId + "' to inherit from", e);
            }
            catch (ClassCastException e) {
                throw new FlowModelBuilderException("Parent state type '" + parentState.getClass().getName() + "' cannot be merged with state type '" + childState.getClass().getName() + "'", e);
            }
        }
    }

    public String toString() {
        return new ToStringCreator(this).append("resource", this.resource).toString();
    }
}

