/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.core.collection;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.springframework.binding.collection.MapAccessor;
import org.springframework.binding.convert.ConversionExecutionException;
import org.springframework.binding.convert.ConversionExecutor;
import org.springframework.binding.convert.ConversionService;
import org.springframework.binding.convert.service.DefaultConversionService;
import org.springframework.core.style.StylerUtils;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.core.collection.ParameterMap;

public class LocalParameterMap
implements ParameterMap,
Serializable {
    private static final DefaultConversionService DEFAULT_CONVERSION_SERVICE = new DefaultConversionService();
    private Map parameters;
    private transient MapAccessor parameterAccessor;
    private transient ConversionService conversionService;

    public LocalParameterMap(Map parameters) {
        this(parameters, DEFAULT_CONVERSION_SERVICE);
    }

    public LocalParameterMap(Map parameters, ConversionService conversionService) {
        this.initParameters(parameters);
        this.conversionService = conversionService;
    }

    public boolean equals(Object o) {
        if (!(o instanceof LocalParameterMap)) {
            return false;
        }
        LocalParameterMap other = (LocalParameterMap)o;
        return this.parameters.equals(other.parameters);
    }

    public int hashCode() {
        return this.parameters.hashCode();
    }

    public Map asMap() {
        return Collections.unmodifiableMap(this.parameterAccessor.asMap());
    }

    public boolean isEmpty() {
        return this.parameters.isEmpty();
    }

    public int size() {
        return this.parameters.size();
    }

    public boolean contains(String parameterName) {
        return this.parameters.containsKey(parameterName);
    }

    public String get(String parameterName) {
        return this.get(parameterName, (String)null);
    }

    public String get(String parameterName, String defaultValue) {
        if (!this.parameters.containsKey(parameterName)) {
            return defaultValue;
        }
        Object value = this.parameters.get(parameterName);
        if (value.getClass().isArray()) {
            this.parameterAccessor.assertKeyValueInstanceOf(parameterName, value, String[].class);
            String[] array = (String[])value;
            if (array.length == 0) {
                return null;
            }
            String first = ((String[])value)[0];
            this.parameterAccessor.assertKeyValueInstanceOf(parameterName, first, String.class);
            return first;
        }
        this.parameterAccessor.assertKeyValueInstanceOf(parameterName, value, String.class);
        return (String)value;
    }

    public String[] getArray(String parameterName) {
        if (!this.parameters.containsKey(parameterName)) {
            return null;
        }
        Object value = this.parameters.get(parameterName);
        if (value.getClass().isArray()) {
            this.parameterAccessor.assertKeyValueInstanceOf(parameterName, value, String[].class);
            return (String[])value;
        }
        this.parameterAccessor.assertKeyValueInstanceOf(parameterName, value, String.class);
        return new String[]{(String)value};
    }

    public Object[] getArray(String parameterName, Class targetElementType) throws ConversionExecutionException {
        String[] parameters = this.getArray(parameterName);
        return parameters != null ? this.convert(parameters, targetElementType) : null;
    }

    public Object get(String parameterName, Class targetType) throws ConversionExecutionException {
        return this.get(parameterName, targetType, null);
    }

    public Object get(String parameterName, Class targetType, Object defaultValue) throws ConversionExecutionException {
        String parameter;
        if (defaultValue != null) {
            this.assertAssignableTo(targetType, defaultValue.getClass());
        }
        return (parameter = this.get(parameterName)) != null ? this.convert(parameter, targetType) : defaultValue;
    }

    public String getRequired(String parameterName) throws IllegalArgumentException {
        this.parameterAccessor.assertContainsKey(parameterName);
        return this.get(parameterName);
    }

    public String[] getRequiredArray(String parameterName) throws IllegalArgumentException {
        this.parameterAccessor.assertContainsKey(parameterName);
        return this.getArray(parameterName);
    }

    public Object[] getRequiredArray(String parameterName, Class targetElementType) throws IllegalArgumentException, ConversionExecutionException {
        String[] parameters = this.getRequiredArray(parameterName);
        return this.convert(parameters, targetElementType);
    }

    public Object getRequired(String parameterName, Class targetType) throws IllegalArgumentException, ConversionExecutionException {
        return this.convert(this.getRequired(parameterName), targetType);
    }

    public Number getNumber(String parameterName, Class targetType) throws ConversionExecutionException {
        this.assertAssignableTo(Number.class, targetType);
        return (Number)this.get(parameterName, targetType);
    }

    public Number getNumber(String parameterName, Class targetType, Number defaultValue) throws ConversionExecutionException {
        this.assertAssignableTo(Number.class, targetType);
        return (Number)this.get(parameterName, targetType, defaultValue);
    }

    public Number getRequiredNumber(String parameterName, Class targetType) throws IllegalArgumentException, ConversionExecutionException {
        this.assertAssignableTo(Number.class, targetType);
        return (Number)this.getRequired(parameterName, targetType);
    }

    public Integer getInteger(String parameterName) throws ConversionExecutionException {
        return (Integer)this.get(parameterName, Integer.class);
    }

    public Integer getInteger(String parameterName, Integer defaultValue) throws ConversionExecutionException {
        return (Integer)this.get(parameterName, Integer.class, defaultValue);
    }

    public Integer getRequiredInteger(String parameterName) throws IllegalArgumentException, ConversionExecutionException {
        return (Integer)this.getRequired(parameterName, Integer.class);
    }

    public Long getLong(String parameterName) throws ConversionExecutionException {
        return (Long)this.get(parameterName, Long.class);
    }

    public Long getLong(String parameterName, Long defaultValue) throws ConversionExecutionException {
        return (Long)this.get(parameterName, Long.class, defaultValue);
    }

    public Long getRequiredLong(String parameterName) throws IllegalArgumentException, ConversionExecutionException {
        return (Long)this.getRequired(parameterName, Long.class);
    }

    public Boolean getBoolean(String parameterName) throws ConversionExecutionException {
        return (Boolean)this.get(parameterName, Boolean.class);
    }

    public Boolean getBoolean(String parameterName, Boolean defaultValue) throws ConversionExecutionException {
        return (Boolean)this.get(parameterName, Boolean.class, defaultValue);
    }

    public Boolean getRequiredBoolean(String parameterName) throws IllegalArgumentException, ConversionExecutionException {
        return (Boolean)this.getRequired(parameterName, Boolean.class);
    }

    public MultipartFile getMultipartFile(String parameterName) {
        return (MultipartFile)this.parameterAccessor.get((Object)parameterName, MultipartFile.class);
    }

    public MultipartFile getRequiredMultipartFile(String parameterName) throws IllegalArgumentException {
        return (MultipartFile)this.parameterAccessor.getRequired(parameterName, MultipartFile.class);
    }

    public AttributeMap asAttributeMap() {
        return new LocalAttributeMap(this.getMapInternal());
    }

    protected void initParameters(Map parameters) {
        this.parameters = parameters;
        this.parameterAccessor = new MapAccessor(this.parameters);
    }

    protected Map getMapInternal() {
        return this.parameters;
    }

    private Object convert(String parameter, Class targetType) throws ConversionExecutionException {
        return this.conversionService.getConversionExecutor(String.class, targetType).execute(parameter);
    }

    private Object[] convert(String[] parameters, Class targetElementType) throws ConversionExecutionException {
        ArrayList<Object> list = new ArrayList<Object>(parameters.length);
        ConversionExecutor converter = this.conversionService.getConversionExecutor(String.class, targetElementType);
        int i = 0;
        while (i < parameters.length) {
            list.add(converter.execute(parameters[i]));
            ++i;
        }
        return list.toArray((Object[])Array.newInstance(targetElementType, parameters.length));
    }

    private void assertAssignableTo(Class clazz, Class requiredType) {
        Assert.isTrue(clazz.isAssignableFrom(requiredType), "The provided required type must be assignable to [" + clazz + "]");
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.parameterAccessor = new MapAccessor(this.parameters);
        this.conversionService = DEFAULT_CONVERSION_SERVICE;
    }

    public String toString() {
        return StylerUtils.style(this.parameters);
    }
}

