/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.oxm.support;

import java.io.IOException;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import org.springframework.oxm.Marshaller;
import org.springframework.util.Assert;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;

public class MarshallingSource
extends SAXSource {
    private final Marshaller marshaller;
    private final Object content;

    public MarshallingSource(Marshaller marshaller, Object content) {
        super(new MarshallingXMLReader(marshaller, content), new InputSource());
        Assert.notNull(marshaller, "'marshaller' must not be null");
        Assert.notNull(content, "'content' must not be null");
        this.marshaller = marshaller;
        this.content = content;
    }

    public Marshaller getMarshaller() {
        return this.marshaller;
    }

    public Object getContent() {
        return this.content;
    }

    public void setInputSource(InputSource inputSource) {
        throw new UnsupportedOperationException("setInputSource is not supported");
    }

    public void setXMLReader(XMLReader reader) {
        throw new UnsupportedOperationException("setXMLReader is not supported");
    }

    private static class MarshallingXMLReader
    implements XMLReader {
        private final Marshaller marshaller;
        private final Object content;
        private DTDHandler dtdHandler;
        private ContentHandler contentHandler;
        private EntityResolver entityResolver;
        private ErrorHandler errorHandler;
        private LexicalHandler lexicalHandler;

        private MarshallingXMLReader(Marshaller marshaller, Object content) {
            Assert.notNull(marshaller, "'marshaller' must not be null");
            Assert.notNull(content, "'content' must not be null");
            this.marshaller = marshaller;
            this.content = content;
        }

        public void setContentHandler(ContentHandler contentHandler) {
            this.contentHandler = contentHandler;
        }

        public ContentHandler getContentHandler() {
            return this.contentHandler;
        }

        public void setDTDHandler(DTDHandler dtdHandler) {
            this.dtdHandler = dtdHandler;
        }

        public DTDHandler getDTDHandler() {
            return this.dtdHandler;
        }

        public void setEntityResolver(EntityResolver entityResolver) {
            this.entityResolver = entityResolver;
        }

        public EntityResolver getEntityResolver() {
            return this.entityResolver;
        }

        public void setErrorHandler(ErrorHandler errorHandler) {
            this.errorHandler = errorHandler;
        }

        public ErrorHandler getErrorHandler() {
            return this.errorHandler;
        }

        protected LexicalHandler getLexicalHandler() {
            return this.lexicalHandler;
        }

        public boolean getFeature(String name) throws SAXNotRecognizedException {
            throw new SAXNotRecognizedException(name);
        }

        public void setFeature(String name, boolean value) throws SAXNotRecognizedException {
            throw new SAXNotRecognizedException(name);
        }

        public Object getProperty(String name) throws SAXNotRecognizedException {
            if ("http://xml.org/sax/properties/lexical-handler".equals(name)) {
                return this.lexicalHandler;
            }
            throw new SAXNotRecognizedException(name);
        }

        public void setProperty(String name, Object value) throws SAXNotRecognizedException {
            if (!"http://xml.org/sax/properties/lexical-handler".equals(name)) {
                throw new SAXNotRecognizedException(name);
            }
            this.lexicalHandler = (LexicalHandler)value;
        }

        public void parse(InputSource input) throws SAXException {
            this.parse();
        }

        public void parse(String systemId) throws SAXException {
            this.parse();
        }

        private void parse() throws SAXException {
            SAXResult result = new SAXResult(this.getContentHandler());
            result.setLexicalHandler(this.getLexicalHandler());
            try {
                this.marshaller.marshal(this.content, result);
            }
            catch (IOException ex) {
                SAXParseException saxException = new SAXParseException(ex.getMessage(), null, null, -1, -1, ex);
                ErrorHandler errorHandler = this.getErrorHandler();
                if (errorHandler != null) {
                    errorHandler.fatalError(saxException);
                }
                throw saxException;
            }
        }
    }
}

