/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.support.destination;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Session;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.jms.support.destination.DestinationResolutionException;
import org.springframework.jms.support.destination.DestinationResolver;
import org.springframework.util.Assert;

public class BeanFactoryDestinationResolver
implements DestinationResolver,
BeanFactoryAware {
    private BeanFactory beanFactory;

    public BeanFactoryDestinationResolver() {
    }

    public BeanFactoryDestinationResolver(BeanFactory beanFactory) {
        Assert.notNull(beanFactory, "BeanFactory is required");
        this.beanFactory = beanFactory;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public Destination resolveDestinationName(Session session, String destinationName, boolean pubSubDomain) throws JMSException {
        Assert.state(this.beanFactory != null, "BeanFactory is required");
        try {
            return this.beanFactory.getBean(destinationName, Destination.class);
        }
        catch (BeansException ex) {
            throw new DestinationResolutionException("Failed to look up Destinaton bean with name '" + destinationName + "'", ex);
        }
    }
}

