/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.method;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.binding.convert.ConversionService;
import org.springframework.binding.convert.service.DefaultConversionService;
import org.springframework.binding.method.MethodInvocationException;
import org.springframework.binding.method.MethodKey;
import org.springframework.binding.method.MethodSignature;
import org.springframework.binding.method.Parameter;
import org.springframework.binding.method.Parameters;
import org.springframework.core.style.StylerUtils;
import org.springframework.util.CachingMapDecorator;

public class MethodInvoker {
    private static final Log logger = LogFactory.getLog(MethodInvoker.class);
    private ConversionService conversionService = new DefaultConversionService();
    private CachingMapDecorator methodCache = new CachingMapDecorator(true){

        public Object create(Object key) {
            return ((MethodKey)key).getMethod();
        }
    };

    public void setConversionService(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public Object invoke(MethodSignature signature, Object bean, Object argumentSource) throws MethodInvocationException {
        Object argument;
        Parameters parameters = signature.getParameters();
        Object[] arguments = new Object[parameters.size()];
        int i = 0;
        while (i < parameters.size()) {
            Parameter parameter = parameters.getParameter(i);
            argument = parameter.evaluateArgument(argumentSource);
            arguments[i] = this.applyTypeConversion(argument, parameter.getType());
            ++i;
        }
        Class[] parameterTypes = parameters.getTypesArray();
        int i2 = 0;
        while (i2 < parameterTypes.length) {
            if (parameterTypes[i2] == null && (argument = arguments[i2]) != null) {
                parameterTypes[i2] = argument.getClass();
            }
            ++i2;
        }
        MethodKey key = new MethodKey(bean.getClass(), signature.getMethodName(), parameterTypes);
        try {
            Method method = (Method)this.methodCache.get(key);
            if (logger.isDebugEnabled()) {
                logger.debug("Invoking method with signature [" + key + "] with arguments " + StylerUtils.style(arguments) + " on bean [" + bean + "]");
            }
            Object returnValue = method.invoke(bean, arguments);
            if (logger.isDebugEnabled()) {
                logger.debug("Invoked method with signature [" + key + "] returned value [" + returnValue + "]");
            }
            return returnValue;
        }
        catch (InvocationTargetException e) {
            throw new MethodInvocationException(signature, arguments, e.getTargetException());
        }
        catch (Exception e) {
            throw new MethodInvocationException(signature, arguments, e);
        }
    }

    protected Object applyTypeConversion(Object value, Class targetType) {
        if (value == null || targetType == null) {
            return value;
        }
        return this.conversionService.getConversionExecutor(value.getClass(), targetType).execute(value);
    }
}

