/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.expression.support;

import org.springframework.binding.expression.EvaluationException;
import org.springframework.binding.expression.Expression;
import org.springframework.core.style.ToStringCreator;

public class CompositeStringExpression
implements Expression {
    private Expression[] expressions;

    public CompositeStringExpression(Expression[] expressions) {
        this.expressions = expressions;
    }

    public Object getValue(Object context) throws EvaluationException {
        StringBuffer buffer = new StringBuffer(128);
        int i = 0;
        while (i < this.expressions.length) {
            buffer.append(this.expressions[i].getValue(context));
            ++i;
        }
        return buffer.toString();
    }

    public void setValue(Object context, Object value) throws EvaluationException {
        throw new UnsupportedOperationException("Cannot set a composite string expression value");
    }

    public Class getValueType(Object context) {
        return String.class;
    }

    public String getExpressionString() {
        return null;
    }

    public String toString() {
        return new ToStringCreator(this).append("expressions", this.expressions).toString();
    }
}

