/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.rs.util;

import java.beans.PropertyChangeListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.StreamingOutput;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.eclipse.persistence.dynamic.DynamicEntity;
import org.eclipse.persistence.internal.dynamic.DynamicEntityImpl;
import org.eclipse.persistence.jaxb.JAXBMarshaller;
import org.eclipse.persistence.jpa.rs.PersistenceContext;
import org.eclipse.persistence.jpa.rs.exceptions.UnsupportedMediaTypeException;
import org.eclipse.persistence.jpa.rs.util.JPARSLogger;
import org.eclipse.persistence.jpa.rs.util.list.MultiResultQueryList;
import org.eclipse.persistence.jpa.rs.util.xmladapters.LinkAdapter;

public class StreamingOutputMarshaller
implements StreamingOutput {
    public static final String NO_ROUTE_JAXB_ELEMENT_LABEL = "result";
    private PersistenceContext context;
    private Object result;
    private MediaType mediaType;

    public StreamingOutputMarshaller(PersistenceContext context, Object result, MediaType acceptedType) {
        this.context = context;
        this.result = result;
        this.mediaType = acceptedType;
    }

    public StreamingOutputMarshaller(PersistenceContext context, Object result, List<MediaType> acceptedTypes) {
        this(context, result, StreamingOutputMarshaller.mediaType(acceptedTypes));
    }

    @Override
    public void write(OutputStream output) throws IOException, WebApplicationException {
        if (this.result instanceof byte[] && this.mediaType.equals(MediaType.APPLICATION_OCTET_STREAM_TYPE)) {
            output.write((byte[])this.result);
            output.flush();
            output.close();
        } else if (this.result instanceof String) {
            OutputStreamWriter writer = new OutputStreamWriter(output);
            writer.write((String)this.result);
            writer.flush();
            writer.close();
        } else {
            if (this.context != null && this.context.getJAXBContext() != null && this.result != null && (this.mediaType.equals(MediaType.APPLICATION_JSON_TYPE) || this.mediaType.equals(MediaType.APPLICATION_XML_TYPE))) {
                try {
                    if (this.result instanceof MultiResultQueryList) {
                        if (this.mediaType == MediaType.APPLICATION_JSON_TYPE) {
                            this.context.marshallEntity(((MultiResultQueryList)this.result).getItems(), this.mediaType, output);
                        } else {
                            this.context.marshallEntity(this.result, this.mediaType, output);
                        }
                    } else {
                        this.context.marshallEntity(this.result, this.mediaType, output);
                    }
                    return;
                }
                catch (Exception e) {
                    JPARSLogger.exception("jpars_caught_exception", new Object[0], e);
                    throw new WebApplicationException();
                }
            }
            if (this.mediaType.equals(MediaType.APPLICATION_OCTET_STREAM_TYPE)) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(this.result);
                oos.flush();
                oos.close();
                output.write(baos.toByteArray());
            } else {
                JPARSLogger.fine("jpars_could_marshal_requested_result_to_requested_type", new Object[]{this.result});
                throw new WebApplicationException();
            }
        }
    }

    public static MediaType mediaType(List<MediaType> types) {
        MediaType aMediaType = null;
        if (types != null && !types.isEmpty()) {
            JPARSLogger.fine("jpars_requested_type", new Object[]{types});
            int i = 0;
            while (i < types.size()) {
                aMediaType = types.get(i);
                if (aMediaType.isCompatible(MediaType.APPLICATION_JSON_TYPE)) {
                    return MediaType.APPLICATION_JSON_TYPE;
                }
                if (aMediaType.isCompatible(MediaType.APPLICATION_XML_TYPE)) {
                    return MediaType.APPLICATION_XML_TYPE;
                }
                if (aMediaType.isCompatible(MediaType.APPLICATION_OCTET_STREAM_TYPE)) {
                    return MediaType.APPLICATION_OCTET_STREAM_TYPE;
                }
                ++i;
            }
        }
        throw new UnsupportedMediaTypeException(aMediaType != null ? aMediaType.toString() : "unknown");
    }

    public static Marshaller createMarshaller(PersistenceContext context, MediaType mediaType) throws JAXBException {
        JAXBMarshaller marshaller = context.getJAXBContext().createMarshaller();
        marshaller.setProperty("eclipselink.media-type", mediaType.toString());
        marshaller.setProperty("eclipselink.json.include-root", false);
        marshaller.setAdapter(new LinkAdapter(context.getBaseURI().toString(), context));
        marshaller.setListener(new Marshaller.Listener(){

            @Override
            public void beforeMarshal(Object source) {
                if (source instanceof DynamicEntity) {
                    DynamicEntityImpl sourceImpl = (DynamicEntityImpl)source;
                    PropertyChangeListener listener = sourceImpl._persistence_getPropertyChangeListener();
                    sourceImpl._persistence_setPropertyChangeListener(null);
                    ((DynamicEntity)source).set("self", source);
                    sourceImpl._persistence_setPropertyChangeListener(listener);
                }
            }
        });
        return marshaller;
    }

    public static MediaType getResponseMediaType(HttpHeaders headers) {
        List<MediaType> accepts;
        MediaType mediaType = MediaType.TEXT_PLAIN_TYPE;
        if (headers != null && (accepts = headers.getAcceptableMediaTypes()) != null && accepts.size() > 0) {
            try {
                mediaType = StreamingOutputMarshaller.mediaType(accepts);
            }
            catch (Exception exception) {}
        }
        return mediaType;
    }
}

