/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.rs.resources.common;

import java.net.URI;
import java.util.List;
import javax.persistence.Query;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.JAXBElement;
import org.eclipse.persistence.internal.jpa.EJBQueryImpl;
import org.eclipse.persistence.internal.queries.ReportItem;
import org.eclipse.persistence.jpa.rs.PersistenceContext;
import org.eclipse.persistence.jpa.rs.resources.common.AbstractResource;
import org.eclipse.persistence.jpa.rs.util.JPARSLogger;
import org.eclipse.persistence.jpa.rs.util.StreamingOutputMarshaller;
import org.eclipse.persistence.jpa.rs.util.list.SingleResultQueryList;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReportQuery;

public abstract class AbstractSingleResultQueryResource
extends AbstractResource {
    protected Response namedQuerySingleResult(String version, String persistenceUnit, String name, HttpHeaders hh, UriInfo ui, URI baseURI) {
        PersistenceContext app = this.getPersistenceContext(persistenceUnit, baseURI, version, null);
        if (app == null) {
            JPARSLogger.fine("jpars_could_not_find_persistence_context", new Object[]{persistenceUnit});
            return Response.status(Response.Status.NOT_FOUND).type(StreamingOutputMarshaller.getResponseMediaType(hh)).build();
        }
        Query query = app.buildQuery(AbstractSingleResultQueryResource.getMatrixParameters(ui, persistenceUnit), name, AbstractSingleResultQueryResource.getMatrixParameters(ui, name), AbstractSingleResultQueryResource.getQueryParameters(ui));
        DatabaseQuery dbQuery = ((EJBQueryImpl)query).getDatabaseQuery();
        if (dbQuery instanceof ReportQuery) {
            List<ReportItem> reportItems = ((ReportQuery)dbQuery).getItems();
            Object queryResults = query.getSingleResult();
            SingleResultQueryList list = this.populateReportQueryResponse(queryResults, reportItems);
            if (list != null) {
                List<MediaType> acceptableMediaTypes;
                JAXBElement element;
                Object elementValue;
                List<JAXBElement> item = list.getFields();
                if (item != null && item.size() == 1 && (elementValue = (element = item.get(0)).getValue()) instanceof byte[] && (acceptableMediaTypes = hh.getAcceptableMediaTypes()).contains(MediaType.APPLICATION_OCTET_STREAM_TYPE)) {
                    return Response.ok(new StreamingOutputMarshaller(app, elementValue, hh.getAcceptableMediaTypes())).build();
                }
                return Response.ok(new StreamingOutputMarshaller(app, (Object)list, hh.getAcceptableMediaTypes())).build();
            }
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).type(StreamingOutputMarshaller.getResponseMediaType(hh)).build();
        }
        Object queryResults = query.getSingleResult();
        return Response.ok(new StreamingOutputMarshaller(app, queryResults, hh.getAcceptableMediaTypes())).build();
    }

    private SingleResultQueryList populateReportQueryResponse(Object result, List<ReportItem> reportItems) {
        SingleResultQueryList response = new SingleResultQueryList();
        List<JAXBElement> fields = this.createShellJAXBElementList(reportItems, result);
        if (fields == null) {
            return null;
        }
        response.setFields(fields);
        return response;
    }
}

